/*
 * user visible definitions
 */

/*
 * GKS operating state
 */
typedef int		Gos;
#define GGKCL	0
#define GGKOP	1
#define GWSOP	2
#define GWSAC	3
#define GSGOP	4

/*
 * workstation state
 */
typedef int			Gwsstate;
#define GINACTIVE	0
#define GACTIVE		1

/*
 * workstation category
 */
typedef int			Gwscat;
#define GOUTPUT		0
#define GINPUT		1
#define GOUTIN		2
#define GWISS		3
#define GMO			4
#define GMI			5

/*
 * echo switch
 */
typedef int			Gesw;
#define GNOECHO		0
#define GECHO		1

/*
 * clipping indicator enumerations
 */
typedef int			Gclip;
#define GNOCLIP		0
#define GCLIP		1

/*
 * attribute source flag enumerations
 */
typedef int				Gasf;
#define GINDIVIDUAL		0
#define GBUNDLED	 	1

/*
 * text path enumerations
 */
typedef int			Gtxpath;
#define	GTP_RIGHT	0
#define	GTP_LEFT	1
#define	GTP_UP		2
#define	GTP_DOWN	3

/*
 * text alignment enumerations
 */
typedef int			Gtxhor;
#define	GTH_NORMAL	0
#define	GTH_LEFT	1
#define	GTH_CENTER	2
#define	GTH_RIGHT	3

/*
 * these numbers are stupidly based on old vplot text sizes
 */
typedef int			Gtxver;
#define	GTV_NORMAL	0
#define GTV_TOP		8
#define GTV_CAP		6
#define GTV_HALF	3
#define GTV_BASE	0
#define GTV_BOTTOM	(-2)

/*
 * text precision enumerations
 */
typedef int			Gtxprec;
#define	GSTRING		0
#define	GCHAR		1
#define	GSTROKE		2

/*
 * wstran update state
 */
typedef int				Gwstus;
#define GNOTPENDING		0
#define GPENDING		1

/*
 * display surface
 */
typedef int			Gdspsurf;
#define GNOTEMPTY	0
#define GEMPTY		1

/*
 * device units
 */
typedef int			Gdevunits;
#define GDC_METERS	0
#define GDC_OTHER	1

/*
 * coordinate system switch
 */
typedef int		Gcsw;
#define GWC		0
#define GNDC	1

/*
 * viewport input priority
 */
typedef int			Gvpri;
#define GLOWER		0
#define GHIGHER		1

/*
 * segment visibility
 */
typedef int			Gsegvis;
#define GINVISIBLE	0
#define GVISIBLE	1

/*
 * input mode
 */
typedef int			Gimode;
#define GREQUEST	0
#define GSAMPLE		1
#define GEVENT		2

/*
 * input status
 */
typedef int		Gistat;
#define GNONE	0
#define GOK		1

typedef struct {
	float x;
	float y;
} Gpoint;

typedef struct {
	int x;
	int y;
} Gipoint;

typedef struct {
	Gpoint ll;
	Gpoint ur;
} Grect;

typedef struct {
	float xmin;
	float xmax;
	float ymin;
	float ymax;
}Glimit;

typedef struct {
	int hor;
	int ver;
} Gtxalign;

typedef struct {
	int type;
	float width;
	int color;
} Glnbundl;

typedef struct {
	int type;
	float size;
	int color;
} Gmkbundl;

typedef struct {
	int font;
	int prec;
} Gtxfp;

typedef struct {
	Gtxfp fp;
	float exp;
	float space;
	int color;
} Gtxbundl;

typedef struct {
	int inter;
	int style;
	int color;
} Gflbundl;

typedef struct {
	float red;
	float green;
	float blue;
} Gcobundl;

typedef struct {
	int ln_type;
	int ln_width;
	int ln_color;
	int mk_type;
	int mk_size;
	int mk_color;
	int tx_fp;
	int tx_exp;
	int tx_space;
	int tx_color;
	int fl_inter;
	int fl_style;
	int fl_color;
} Gasfs;

/*
 * workstation stuff
 */

typedef struct {
	Glimit w;
	Glimit v;
} Gwstran;

typedef struct {
	int open;
	int active;
	int assoc;
} Gwsmax;

typedef struct {
	int units;
	Gpoint device;
	Gipoint raster;
} Gdspsize;

/*
 * input data records
 */
typedef struct {
	int transform;
	Gpoint position;
} Gloc;


typedef struct {
	int status;
	Gloc loc;
} Gqloc;

typedef struct {
	int pfcf;
	int acf;
	/* asfs */
	int ln_type;
	int ln_width;
	int ln_color;
	int fl_inter;
	int fl_style;
	int fl_color;
	int line;
	Glnbundl lnbundl;
	int fill;
	Gflbundl flbundl;
} Glocrec;

typedef struct {
	int mode;
	int esw;
	Gloc loc;
	int pet;
	Glimit area;
	Glocrec record;
} Glocst;

/*
 * short -> long function identifier mapping
 */

/* 
 * control routines
 */
#define gopengks				gopks
#define gclosegks				gclks
#define gopenws					gopwk
#define gclosews				gclwk
#define gactivatews				gacwk
#define gdeactivatews				gdacwk
#define gclearws				gclrwk
#define gupdatews				guwk
#define gmessage				gmsg

/*
 * output routines
 */
#define gpolyline				gpl
#define gpolymarker				gpm
#define gtext					gtx
#define gfillarea				gfa
#define gcellarray				gca

/*
 * output attribute routines
 */
#define gsetlineind				gspli
#define gsetlinetype			gsln
#define gsetlinewidth			gslwsc
#define gsetlinecolorind		gsplci
#define gsetlinecolourind		gsplci
#define	gsetmarkerind			gspmi
#define	gsetmarkertype			gsmk
#define	gsetmarkersize			gsmksc
#define gsetmarkercolorind		gspmci
#define gsetmarkercolourind		gspmci
#define	gsettextind				gstxi
#define gsettextfontprec		gstxfp
#define gsetcharexpan			gschxp
#define gsetcharspace			gschsp
#define gsettextcolorind		gstxci
#define gsettextcolourind		gstxci
#define gsetcharheight			gschh
#define gsetcharup				gschup
#define gsettextpath			gstxp
#define gsettextalign			gstxal
#define	gsetfillind				gsfai
#define	gsetfillintstyle		gsfais
#define gsetfillstyleind		gsfasi
#define gsetfillcolorind		gsfaci
#define gsetfillcolourind		gsfaci
#define gsetpatsize				gspa
#define gsetpatrefpt			gsparf
#define gsetasf					gsasf
#define gsetpickid				gspkid
#define gsetlinerep				gsplr
#define gsetmarkerrep			gspmr
#define gsettextrep				gstxr
#define gsetfillrep				gsfar
#define gsetpatrep				gspar
#define gsetcolorrep			gscr
#define gsetcolourrep			gscr

/*
 * transformation routines
 */
#define gsetwindow				gswn
#define gsetviewport			gsvp
#define gsetviewportinputpri	gsvpip
#define gselntran				gselnt
#define gsetclip				gsclip
#define gsetwswindow			gswkwn
#define gsetwsviewport			gswkvp

/*
 * segment routines
 */
#define gsetsegtran				gssgt
#define gcreateseg				gcrsg
#define gcloseseg				gclsg
#define gsetvis					gsvis

/*
 * input routines
 */
#define ginitloc				ginlc
#define greqloc					grqlc

/*
 * inquiry routines
 */
#define ginqmaxdisplaysize		gqmds
#define ginqntran				gqnt
#define ginqcharheight			gqchh
#define ginqcurntrannum			gqcntn
#define ginqclip				gqclip
#define ginqmaxntrannum			gqmntn
#define ginqtextcolorind		gqtxci
#define ginqtextcolourind		gqtxci
#define ginqtextfontprec		gqtxfp
#define ginqwsmaxnum			gqwkm
#define ginqwsstate				gqwks

/*
 * utility routines
 */
#define gevaltran				gevtm
#define gaccumtran				gactm

/*
 * error routines
 */
#define gerrorhand				gerhnd
#define gerrorlog				gerlog
#define gemergencyclosegks		geclks
