/*
 * GKS graphics implementation
 * Copyright (c) 1984  Glenn C. Kroeger
 */

/*
 * device switch table entry
 */
typedef struct{
	/*
	 * control
	 */
	int (*open)();
	int (*close)();
	/*
	 * output
	 */
	int (*polyline)();
	int (*polymarker)();
	int (*text)();
	int (*fillarea)();
	int (*cellarray)();
	int (*gdp)();
	/*
	 * workstation functions
	 */
	int (*wscontrol)();
	int (*wsattributes)();
	/*
	 * segment functions
	 */
	int (*segcontrol)();
	int (*segattributes)();
	/*
	 * input
	 */
	int (*locator)();
	int (*stroke)();
	int (*valuator)();
	int (*choice)();
	int (*pick)();
	int (*string)();
	/*
	 * low level entries
	 */
	int (*vector)();
	int (*point)();
} Gdevsw;

typedef struct{
	int xmin;
	int xmax;
	int ymin;
	int ymax;
} Gilimit;

/*
 * everything you need to know to draw a line
 */
typedef struct{
	float *lc_segtran;
	Glimit *lc_cliprect;
	Glnbundl lc_individual;
	int lc_index;
	int lc_typeasf;
	int lc_widthasf;
	int lc_colorasf;
} Glncontrol;

/*
 * ditto markers
 */
typedef struct{
	float *mc_segtran;
	Glimit *mc_cliprect;
	Gmkbundl mc_individual;
	int mc_index;
	int mc_typeasf;
	int mc_sizeasf;
	int mc_colorasf;
} Gmkcontrol;

typedef struct{
	float *tc_segtran;
	Glimit *tc_cliprect;
	Gtxalign tc_align;
	Gpoint	tc_up;
	Gpoint	tc_path;
	Gtxbundl tc_individual;
	int tc_index;
	int tc_fpasf;
	int tc_expasf;
	int tc_spaceasf;
	int tc_colorasf;
} Gtxcontrol;



/*
 * workstation types
 */
#define gmajordev(A)	((A)>>3)

/*
 * metafiles
 */
#define METAFILE 	001
#define VPLOT		001
#define GKSM		011

/*
 * tek 401X series
 */
#define TEK4010			020
#define TEK4014			021
/* emulators */
#define GRAPHON			022
#define RETROGRAPHICS	023
#define SELENAR			024
#define DSCAN			025

/*
 * tek 4105
 */
#define TEK4105		030
#define TGRAF05		031

/*
 * tek 410[6-9] series 
 */
#define TEK4106		040
#define TEK4107		041
#define TEK4109		042
#define TGRAF07		043

/*
 * envision
 */
#define ENV215		050
#define ENV220		051

#ifndef DOS
/*
 * DEC REGIS attrocities
 * these are replaced by verticom boards on PCs since we assume that anyone
 * with enough brains to use PCs would trash all REGIS machines
 */
#define GIGI	060
#define VT125	061

#else
/*
 * Verticom M and H series boards for IBM PCs
 */
#define VGCM16		060
#define VGCM256		061
#define VGCH16		062
#define VGCH256		063
#endif
