/*
 * GKS FUNCTION NAME:  Error Logger
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gerrorlog(error,functionname)
 *
 *        int error;
 *        char *functionname;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gerlog(error,functionname)
 *
 *        integer error
 *        character functionname
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"
#include "errorstr.h"

#ifdef FORTRAN

#define GERLOG	gerlog_
#define ERROR	*error

#else

#define GERLOG	gerlog
#define ERROR	error

#endif

GERLOG(error,functionname)
int ERROR;
char *functionname;
{
	if(_gks.errfile)
	{
		fprintf(_gks.errfile,"GKS error %d in function %s\n",
				ERROR,functionname);
		if( _gerrorstring[ERROR])
			fprintf(_gks.errfile,"    %s\n",_gerrorstring[ERROR]);
		fflush(_gks.errfile);
	}
	return(ERROR);
}
