/*
 * GKS FUNCTION NAME:  Error Handler
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gerrorhand(error,functionname)
 *
 *        int error;
 *        char *functionname;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gerhnd(error,functionname)
 *
 *        integer error
 *        character functionname
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

#ifdef FORTRAN

#define GERHND	gerhnd_
#define GERRORLOG gerlog_
#define ERROR	*error

#else

#define GERHND	gerhnd
#define GERRORLOG gerrorlog
#define ERROR	error

#endif

GERHND(error,functionname)
int ERROR;
char *functionname;
{
	GERRORLOG(error,functionname);
	return(ERROR);
}
