/*
 * GKS FUNCTION NAME:  Emergency Close GKS
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gemergencyclosegks()
 *
 *    FORTRAN SYNTAX:
 *
 *        call geclks()
 *
   Revisions:
	2 Jul 1990 - P. Farrell - GECLKS function must be declared of type
   "void" on Digital RISC ULTRIX systems (DECsystem, DECstation).  I 
   included an ifdef that will do this properly, based on automatic compiler
   flag "MIPSEL" for such machines.  For BSD UNIX, stays as type "int".
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

#ifdef FORTRAN

#define GECLKS	geclks_

#else

#define GECLKS	geclks

#endif

#ifdef MIPSEL
void GECLKS()
#else
int GECLKS()
#endif
{
	register Gwsstatelist *wsptr;
	register int i;
	register Gdevsw *dev;

	for( i=0; i < NWORKSTATION; i++)
	{
		if( wsptr = _gks.workstation[i])
		{
			dev = _gdevsw + gmajordev(wsptr->type);
			if(dev->close) (*(dev->close))(wsptr);
		}
	}
	exit(-1);
}
