#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "wstable.h"
#include "metafile.h"
#include "gksstate.h"
#include "extern.h"
#include "vplot.h"
#include "vpc.h"
char *malloc();

Gwstable vplot_wstable={
	GOUTPUT,
	{ GDC_METERS, {1.27, 1.27}, {30000, 30000}}
};

vplot_open(wsptr)
Gwsstatelist *wsptr;
{
	wsptr->scratchpad = malloc( sizeof(struct vplotcontrol));

	/*
	 * scale down default viewport from vplot maxima to size A
	 */
	wsptr->reqviewport.xmax = 0.267;
	wsptr->reqviewport.ymax = 0.200;
	wsptr->tranudpending = GPENDING;

	putc( VP_SETSTYLE, wsptr->outfile);
	putc( 's', wsptr->outfile);
	return;
}

vplot_pline(npts,points,lncontrol,wsptr)
register int npts;
Gpoint *points;
Glncontrol *lncontrol;
register Gwsstatelist *wsptr;
{
	register struct vplotcontrol *vpc =
								(struct vplotcontrol *)wsptr->scratchpad;
	int fat;
	double nettran[2][3];
	Glimit netcliprect;
	Glnbundl lnattr;

	if(gen_udwstran(wsptr,lncontrol->lc_segtran,lncontrol->lc_cliprect,
					nettran,&netcliprect))
	{
		wsptr->scale *= METERSTOVPLOT;
		wsptr->xshift *= METERSTOVPLOT;
		wsptr->yshift *= METERSTOVPLOT;
		netcliprect.xmin *= METERSTOVPLOT;
		netcliprect.xmax *= METERSTOVPLOT;
		netcliprect.ymin *= METERSTOVPLOT;
		netcliprect.ymax *= METERSTOVPLOT;
		nettran[0][0] *= METERSTOVPLOT;
		nettran[0][1] *= METERSTOVPLOT;
		nettran[0][2] *= METERSTOVPLOT;
		nettran[1][0] *= METERSTOVPLOT;
		nettran[1][1] *= METERSTOVPLOT;
		nettran[1][2] *= METERSTOVPLOT;
	}
	vplot_cliprect(&netcliprect,wsptr);
	netcliprect.xmin = netcliprect.ymin = 0.;
	netcliprect.xmax = netcliprect.ymax = VPCMAX;

	/*
	 * update attributes
	 */
	gen_wslnattr(wsptr,lncontrol,&lnattr);

	switch(lnattr.type)
	{
	case 2:
		vpc->dashon = 1;
		vpc->dashdef[0] = 180.;
		vpc->dashdef[1] = 260.;
		vpc->dashdef[2] = 440.;
		vpc->dashdef[3] = 520.;
		break;
	case 3:
		vpc->dashon = 1;
		vpc->dashdef[0] = 24.;
		vpc->dashdef[1] = 90.;
		vpc->dashdef[2] = 114.;
		vpc->dashdef[3] = 180.;
		break;
	case 4:
		vpc->dashon = 1;
		vpc->dashdef[0] = 180.;
		vpc->dashdef[1] = 270.;
		vpc->dashdef[2] = 300.;
		vpc->dashdef[3] = 390.;
		break;
	default:
		vpc->dashon = 0;
		break;
	}

	fat=(int)(lnattr.width+0.5)-1;
	if( fat < 0) fat=0;
	if( vpc->vpfat != fat) vplot_fat(fat,wsptr);

	if( vpc->vpcolor != lnattr.color)
		vplot_color(lnattr.color,wsptr);

	vpc->dashpos = 0.0;	

	gen_pline(npts,points,nettran,&netcliprect,0,0,wsptr);

	putc( VP_PURGE, wsptr->outfile);
	fflush(wsptr->outfile);
	wsptr->displaysurfempty == GNOTEMPTY;
}

vplot_pmark(npts,points,mkcontrol,wsptr)
register int npts;
Gpoint *points;
Gmkcontrol *mkcontrol;
register Gwsstatelist *wsptr;
{
	register Gpoint *p=points;
	register struct vplotcontrol *vpc =
								(struct vplotcontrol *)wsptr->scratchpad;
	register int xp,yp;
	double tempf;
	int marksize;
	double nettran[2][3];
	Glimit netcliprect;
	Gmkbundl mkattr;

	if(gen_udwstran(wsptr,mkcontrol->mc_segtran,mkcontrol->mc_cliprect,
					nettran,&netcliprect))
	{
		wsptr->scale *= METERSTOVPLOT;
		wsptr->xshift *= METERSTOVPLOT;
		wsptr->yshift *= METERSTOVPLOT;
		netcliprect.xmin *= METERSTOVPLOT;
		netcliprect.xmax *= METERSTOVPLOT;
		netcliprect.ymin *= METERSTOVPLOT;
		netcliprect.ymax *= METERSTOVPLOT;
		nettran[0][0] *= METERSTOVPLOT;
		nettran[0][1] *= METERSTOVPLOT;
		nettran[0][2] *= METERSTOVPLOT;
		nettran[1][0] *= METERSTOVPLOT;
		nettran[1][1] *= METERSTOVPLOT;
		nettran[1][2] *= METERSTOVPLOT;
	}
	vplot_cliprect(&netcliprect,wsptr);
	netcliprect.xmin = netcliprect.ymin = 0.;
	netcliprect.xmax = netcliprect.ymax = VPCMAX;

	/*
	 * update attributes
	 */
	gen_wsmkattr(wsptr,mkcontrol,&mkattr);
	if( vpc->vpcolor != mkattr.color)
		vplot_color(mkattr.color,wsptr);
	
	marksize = (int)(mkattr.size * 6.);
	if( (marksize < 1) || (mkattr.type == 1)) marksize = 1;

	putc(VP_PMARK,wsptr->outfile);
	vplot_puth(npts,wsptr);
	vplot_puth(mkattr.type,wsptr);
	vplot_puth(marksize,wsptr);

	while(npts--)
	{
		tempf = (nettran[0][0] * p->x) + (nettran[0][1] * p->y)
				+ nettran[0][2];
		xp = (tempf < 0.)?(int)(tempf - 0.5):(int)(tempf + 0.5);
		tempf = (nettran[1][0] * p->x) + (nettran[1][1] * p->y)
				+ nettran[1][2];
		yp = (tempf < 0.)?(int)(tempf - 0.5):(int)(tempf + 0.5);
		vplot_point(xp,yp,wsptr);
		p++;
	}
	putc( VP_PURGE, wsptr->outfile);
	fflush(wsptr->outfile);
	wsptr->displaysurfempty == GNOTEMPTY;
}

#define TEXTFATRATIO	0.3
vplot_text(point,string,txcontrol,wsptr)
Gpoint *point;
register char *string;
Gtxcontrol *txcontrol;
register Gwsstatelist *wsptr;
{
	register struct vplotcontrol *vpc =
								(struct vplotcontrol *)wsptr->scratchpad;
	int xp,yp;
	double tempf;
	int size,orient;
	int txfat;
	double angle,fsize,atan2(),sqrt();
	Gpoint wsup,wspath;
	Gtxbundl txattr;
	double nettran[2][3];
	Glimit netcliprect;

	if(gen_udwstran(wsptr,txcontrol->tc_segtran,txcontrol->tc_cliprect,
					nettran,&netcliprect))
	{
		wsptr->scale *= METERSTOVPLOT;
		wsptr->xshift *= METERSTOVPLOT;
		wsptr->yshift *= METERSTOVPLOT;
		netcliprect.xmin *= METERSTOVPLOT;
		netcliprect.xmax *= METERSTOVPLOT;
		netcliprect.ymin *= METERSTOVPLOT;
		netcliprect.ymax *= METERSTOVPLOT;
		nettran[0][0] *= METERSTOVPLOT;
		nettran[0][1] *= METERSTOVPLOT;
		nettran[0][2] *= METERSTOVPLOT;
		nettran[1][0] *= METERSTOVPLOT;
		nettran[1][1] *= METERSTOVPLOT;
		nettran[1][2] *= METERSTOVPLOT;
	}
	vplot_cliprect(&netcliprect,wsptr);

	/*
	 * update text attributes 
	 */
	gen_wstxattr(wsptr,txcontrol,&txattr);

	if( vpc->vpcolor != txattr.color)
		vplot_color(txattr.color,wsptr);

	if( (vpc->vptxalign.hor != txcontrol->tc_align.hor) ||
		(vpc->vptxalign.ver != txcontrol->tc_align.ver))
	{
		putc( VP_TXALIGN, wsptr->outfile);
		vplot_puth(txcontrol->tc_align.hor,wsptr);
		vplot_puth(txcontrol->tc_align.ver,wsptr);
		vpc->vptxalign = txcontrol->tc_align;
	}

	if( (vpc->vpfontprec.font != txattr.fp.font - 1) ||
		(vpc->vpfontprec.prec != txattr.fp.prec))
	{
		putc( VP_TXFONTPREC, wsptr->outfile);
		vplot_puth(txattr.fp.font - 1, wsptr);
		vplot_puth(txattr.fp.prec, wsptr);
		vplot_puth(OVLY_NORMAL, wsptr);
		vpc->vpfontprec.font = txattr.fp.font - 1;
		vpc->vpfontprec.prec = txattr.fp.prec;
	}

	wsup.x = (nettran[0][0] * txcontrol->tc_up.x) +
			 (nettran[0][1] * txcontrol->tc_up.y);
	wsup.y = (nettran[1][0] * txcontrol->tc_up.x) +
			 (nettran[1][1] * txcontrol->tc_up.y);
	wspath.x = (nettran[0][0] * txcontrol->tc_path.x) +
			   (nettran[0][1] * txcontrol->tc_path.y);
	wspath.y = (nettran[1][0] * txcontrol->tc_path.x) +
			   (nettran[1][1] * txcontrol->tc_path.y);

	angle = ( 180./PI) * atan2((double)wspath.y,(double)wspath.x);
	orient = ( (angle < 0.) ? ((int)(angle - 0.5)) : ((int)(angle + 0.5)));

	fsize = sqrt((double)(wsup.x * wsup.x) + (double)(wsup.y * wsup.y));
	size = (int)((fsize/20.) + 0.5);
	if( size < 1) size = 1;
	txfat = (int)((size * TEXTFATRATIO) + 0.5);
	vplot_fat(txfat, wsptr);

	tempf = (nettran[0][0] * point->x) + (nettran[0][1] * point->y)
			+ nettran[0][2];
	xp = (tempf > 0.) ? (int)(tempf + 0.5) : (int)(tempf - 0.5);
	tempf = (nettran[1][0] * point->x) + (nettran[1][1] * point->y)
			+ nettran[1][2];
	yp = (tempf > 0.) ? (int)(tempf + 0.5) : (int)(tempf - 0.5);

	if((xp < -VPCMAX) || (xp > VPCMAX) || (yp < -VPCMAX) || (yp > VPCMAX))
		return;
	putc( VP_MOVE, wsptr->outfile);
	vplot_point(xp,yp,wsptr);
	vpc->xold = xp; vpc->yold = yp;

	putc(VP_TEXT,wsptr->outfile);
	vplot_puth(size,wsptr);
	vplot_puth(orient,wsptr);
	do { putc (*string,wsptr->outfile); } while (*string++);

	putc( VP_PURGE, wsptr->outfile);
	fflush(wsptr->outfile);
	wsptr->displaysurfempty == GNOTEMPTY;
}

vplot_wscontrol(command,wsptr,arg)
int command;
Gwsstatelist *wsptr;
char *arg;
{
	switch(command)
	{
	case CLEAR:
		putc( VP_ERASE, wsptr->outfile);
		fflush(wsptr->outfile);
		wsptr->displaysurfempty = GEMPTY;
		break;
	case UPDATE:
		putc( VP_PURGE, wsptr->outfile);
		fflush(wsptr->outfile);
		break;
	case REDRAW_ALL_SEGMENTS_ON:
	case SET_DEFFERAL_STATE_OF:
	case SEND_MESSAGE_TO:
	case SEND_ESCAPE_TO:
		break;
	}
	return;
}

vplot_vector(x1,y1,x2,y2,wsptr)
int x1,y1,x2,y2;
Gwsstatelist *wsptr;
{
	register struct vplotcontrol *vpc =
								(struct vplotcontrol *)wsptr->scratchpad;
	double dx,dy,dist,dpos,xp,yp,tonext,cosine,sine;
	register int i;
	double vplot_fmod(),sqrt();

	if((vpc->xold != x1) || (vpc->yold != y1))
	{
		putc( VP_MOVE, wsptr->outfile);
		vplot_point(x1,y1,wsptr);
	}

	if (!(vpc->dashon))	/* if solid line style */
	{
		putc( VP_DRAW, wsptr->outfile);
		vplot_point(x2,y2,wsptr); 			
		vpc->xold = x2; vpc->yold = y2;
		vpc->dashpos = 0.0;				/* reset position in dashes */
		return;
	}

	dx = (double)(x2-x1); dy = (double)(y2-y1);
	dist = sqrt(dx*dx+dy*dy);
	if (dist <= 0.) return;					/* return if no change */
	cosine = dx/dist;  sine = dy/dist;
	dpos = vpc->dashpos;					/* current position in dashes */
	vpc->dashpos = vplot_fmod(dpos+dist,vpc->dashdef[3]);

	/* index to dash def */
	for (i = 0; i < 4 && vpc->dashdef[i] <= dpos; i++);
	xp = (double)(x1); yp = (double)(y1);
	while (dist > 0.0)
	{
		tonext = vpc->dashdef[i]-dpos;	/* dist to next gap or dash */
		if (tonext > dist) tonext = dist;
		xp += tonext*cosine; yp += tonext*sine;
		if(i%2)
			putc( VP_MOVE, wsptr->outfile);
		else
			putc( VP_DRAW, wsptr->outfile);
		x2 = (int)(xp + 0.5);
		y2 = (int)(yp + 0.5);
		vplot_point(x2,y2,wsptr);
		dpos = vpc->dashdef[i];		/* new position */
		i = (i+1)%4;				/* i = 0,1,2, or 3 */
		if (i == 0) dpos = 0.0;		/* back to start of dashes */
		dist -= tonext;
	}
	vpc->xold = x2; vpc->yold = y2;
}

double
vplot_fmod(x,y)
double x,y;
{
	double floor();
	return(x-floor(x/y)*y);
}

vplot_fat(fat,wsptr)
int fat;
Gwsstatelist *wsptr;
{
	register struct vplotcontrol *vpc =
								(struct vplotcontrol *)wsptr->scratchpad;
	putc( VP_FAT, wsptr->outfile);
	vplot_puth(fat,wsptr);
	vpc->vpfat = fat;
	return;
}

vplot_color(color,wsptr)
int color;
Gwsstatelist *wsptr;
{
	register struct vplotcontrol *vpc =
								(struct vplotcontrol *)wsptr->scratchpad;
	putc( VP_COLOR, wsptr->outfile);
	vplot_puth(color,wsptr);
	vpc->vpcolor = color;
	return;
}

vplot_cliprect(rect,wsptr)
Glimit *rect;
register Gwsstatelist *wsptr;
{
	register struct vplotcontrol *vpc = 
								(struct vplotcontrol *)wsptr->scratchpad;
	register int ixmin,ixmax,iymin,iymax;

	ixmin = (int)(rect->xmin + 0.5);
	iymin = (int)(rect->ymin + 0.5);
	ixmax = (int)(rect->xmax + 0.5);
	iymax = (int)(rect->ymax + 0.5);

	if( (ixmin != vpc->cliprect.xmin)||
		(iymin != vpc->cliprect.ymin)||
		(ixmax != vpc->cliprect.xmax)||
		(iymax != vpc->cliprect.ymax))
	{
		putc (VP_WINDOW,wsptr->outfile);
		vplot_point(ixmin,iymin,wsptr);
		vplot_point(ixmax,iymax,wsptr);
		vpc->cliprect.xmin = ixmin;
		vpc->cliprect.ymin = iymin;
		vpc->cliprect.xmax = ixmax;
		vpc->cliprect.ymax = iymax;
	}
	return;
}

vplot_point(x,y,wsptr)
int x,y;
register Gwsstatelist *wsptr;
{
	vplot_puth(x,wsptr);
	vplot_puth(y,wsptr);
}

vplot_puth(x,wsptr)
int x;
register Gwsstatelist *wsptr;
{
/* Glenn's routine (commented out) does this in a byte-order-dependent way. */
	register int j;

	j = x&255; /* low order byte of halfword value */
	x >>= 8;
	putc((char) j, wsptr->outfile);
	j = x&255; /* high order byte of halfword value */
	putc((char) j, wsptr->outfile);
	return(ferror(wsptr->outfile));
}

/*
 * vplot_puth(x,wsptr)
 * int x;
 * register Gwsstatelist *wsptr;
 * {
 * 	register char *p;
 * 	short ix;
 * 
 * 	ix = (short)x;
 * 	p = (char *)&ix;
 * 	putc(*p++, wsptr->outfile); putc(*p, wsptr->outfile);
 * 	return(ferror(wsptr->outfile));
 * }
 */
