 
/* kernel commands */
#define VGC_MULTICOM	0x20	/* load multiple commands */
#define VGC_SELDRIVER	0x31	/* Select and initialize driver */
#define VGC_VDIDRIVER	3		/* VDI driver number */

/* mode setting commands */
#define VGC_IBMCGA 		0x40	/* IBM CGA graphics display */
#define VGC_HIPERF 		0x41	/* VGC graphics display */

#define VGC_CLEAR		0x44	/* clear frame to specified color */

#define VGC_SETCLIP		0x48	/* set clip status */
#define	VGC_NOCLIP		0		/* disable clipping */
#define	VGC_CLIP		1		/* enable clipping */

#define VGC_WINDOW		0x50	/* set window */
#define VGC_VIEWPORT	0x51	/* set viewport */

#define VGC_MOVE		0x60	/* absolute move */
#define VGC_RMOVE		0x61	/* relative move */

#define VGC_POINT		0x62	/* absolute point */
#define VGC_RPOINT		0x63	/* relative point */

#define VGC_LINE		0x64	/* absolute line */
#define VGC_RLINE		0x65	/* relative line */

#define VGC_ORECT		0x66	/* outline absolute rectangle */
#define VGC_ORRECT		0x67	/* outline relative rectangle */

#define VGC_FRECT		0x68	/* fill absolute rectangle */
#define VGC_FRRECT		0x69	/* fill relative rectangle */

#define VGC_OPOLY		0x6a	/* outline absolute polygon */
#define VGC_ORPOLY		0x6b	/* outline relative polygon */

#define VGC_FPOLY		0x6c	/* fill absolute polygon */
#define VGC_FRPOLY		0x6d	/* fill relative polygon */

#define VGC_ATEXT		0x7c	/* output an alpha character string */
#define VGC_GTEXT		0x7d	/* output a graphics character string */

#define VGC_MARKER		0x85	/* marker at CP */

#define VGC_LINEATTR	0x96	/* line attributes */
#define VGC_MARKATTR	0x9a	/* polymarker attributes */
#define VGC_ATXTATTR	0x90	/* alpha text attributes */
#define VGC_GTXTATTR	0x91	/* graphics text attributes */
#define VGC_FILLATTR	0x98	/* area fill attributes */
#define VGC_CURSATTR	0x94	/* cursor attributes */

#define VGC_DEFMARKSIZE	7
#define VGC_SOLID		0

#define VGC_SETCOLOR	0x92	/* set color representation */
#define VGC_WRTMODE		0x9c	/* set pixel writing mode */
#define VGC_SOURCE		4
#define VGC_SELFONT		0x9d	/* Select font */

#define VGC_LOCATOR		0xba	/* set and display locator */
