#include <stdio.h>

#include "../../include/gks.h"
#include "../../include/config.h"
#include "../../include/device.h"
#include "../../include/wsstate.h"
#include "../../include/gksstate.h"
#include "../../include/metafile.h"
#include "../../include/wstable.h"
#include "../../include/extern.h"
#include "vgc.h"
char *malloc();

/*
 * workstation description tables
 */
Gwstable vgcm16_wstable={
	GOUTIN,
	{ GDC_OTHER, {639., 479.}, {639, 479} }
};

Gwstable vgcm256_wstable={
	GOUTIN,
	{ GDC_OTHER, {639., 479.}, {639, 479} }
};

Gwstable vgch16_wstable={
	GOUTIN,
	{ GDC_OTHER, {1000., 750.}, {1000, 750} }
};

Gwstable vgch256_wstable={
	GOUTIN,
	{ GDC_OTHER, {1000., 750.}, {1000, 750} }
};

static struct {
	char	vgc_seldriver;
	char	vgc_driver;
} vgc_init = {			/* Change to the VDI driver */
	VGC_SELDRIVER, VGC_VDIDRIVER
};

static char hiperfmode = VGC_HIPERF;
static char ibmcgamode = VGC_IBMCGA;

static char vgc_cmdbuf[190];
static char *vgc_bufptr;

static struct{
	Gilimit vs_cliprect;
	int vs_linewidth;
	char vs_linecolor;
	char vs_linetype;
	char vs_marktype;
	int vs_marksize;
	char vs_markcolor;
} vgc_stat = {
	{ 0, 0, 0, 0},
	1, 7, VGC_SOLID, 2, VGC_DEFMARKSIZE, 7
};

/*
 * dev->open()
 */
vgc_open(wsptr)
Gwsstatelist *wsptr;
{
	register int cmdcount;
	Gilimit rect;
    /*
	 * select hi-performance mode, load vgc-vdi driver
	 */
    gccmdp (1, &hiperfmode);
    gccmdp (2, &vgc_init);
 
    /*
	 * Initialize writing mode to set
	 */
	vgc_cmdbuf[0] = VGC_WRTMODE;
	vgc_cmdbuf[1] = VGC_SOURCE;
    gccmdp (2, vgc_cmdbuf);
 
 	/*
	 * default the color lookup table
	 */
	vgc_dfcolortable();

    /*
	 * Set the default line and fill colors and styles
	 */
	vgc_cmdbuf[0] = VGC_MULTICOM;
	vgc_bufptr = vgc_cmdbuf + 2;
	vgc_lineattr();
	vgc_markattr();

    /*
	 * Define the window and viewport to be the whole screen
	 */
	rect.xmin = rect.ymin = 0;
	if((wsptr->type == VGCH16) || (wsptr->type == VGCH256))
	{
		rect.xmax = 999;
		rect.ymax = 749;
	}
	else
	{
		rect.xmax = 639;
		rect.ymax = 479;
	}
	vgc_cliprect(&rect);
	*(vgc_bufptr++) = VGC_SETCLIP;
	*(vgc_bufptr++) = VGC_CLIP;

	cmdcount = vgc_bufptr - vgc_cmdbuf;
	vgc_cmdbuf[1] = (cmdcount - 2) & 0xff;
    gccmdp (cmdcount,vgc_cmdbuf);
 
	vgc_wscontrol(CLEAR,wsptr);
	return;
}

/*
 * dev->close()
 */
vgc_close(wsptr)
register Gwsstatelist *wsptr;
{
  	gccmdp (1, &ibmcgamode);
}

/*
 * dev->wscontrol
 */
vgc_wscontrol(command,wsptr,arg)
int command;
Gwsstatelist *wsptr;
char *arg;
{
	switch(command)
	{
	case CLEAR:
		vgc_cmdbuf[0] = VGC_CLEAR;
		vgc_cmdbuf[1] = 0;
  		gccmdp (2, vgc_cmdbuf);
		wsptr->displaysurfempty = GEMPTY;
		break;
	case UPDATE:
		break;
	case REDRAW_ALL_SEGMENTS_ON:
	case SET_DEFFERAL_STATE_OF:
	case SEND_MESSAGE_TO:
	case SEND_ESCAPE_TO:
		break;
	}
	return;
}

vgc_cliprect(rect)
Gilimit *rect;
{
	register int i;
	int needrect=0;

	if(rect->xmin != vgc_stat.vs_cliprect.xmin) 
	{
		vgc_stat.vs_cliprect.xmin =  rect->xmin;
		needrect++;
	}
	if(rect->xmax != vgc_stat.vs_cliprect.xmax) 
	{
		vgc_stat.vs_cliprect.xmax =  rect->xmax;
		needrect++;
	}
	if(rect->ymin != vgc_stat.vs_cliprect.ymin) 
	{
		vgc_stat.vs_cliprect.ymin =  rect->ymin;
		needrect++;
	}
	if(rect->ymax != vgc_stat.vs_cliprect.ymax) 
	{
		vgc_stat.vs_cliprect.ymax =  rect->ymax;
		needrect++;
	}

	if(needrect)
	{
		for(i=0; i<2; i++)
		{
			if(i)
				*(vgc_bufptr++) = VGC_WINDOW;
			else
				*(vgc_bufptr++) = VGC_VIEWPORT;

			*(vgc_bufptr++) = vgc_stat.vs_cliprect.xmin & 0xff;
			*(vgc_bufptr++) = (vgc_stat.vs_cliprect.xmin>>8) & 0xff;
			*(vgc_bufptr++) = vgc_stat.vs_cliprect.ymin & 0xff;
			*(vgc_bufptr++) = (vgc_stat.vs_cliprect.ymin>>8) & 0xff;
			*(vgc_bufptr++) = vgc_stat.vs_cliprect.xmax & 0xff;
			*(vgc_bufptr++) = (vgc_stat.vs_cliprect.xmax>>8) & 0xff;
			*(vgc_bufptr++) = vgc_stat.vs_cliprect.ymax & 0xff;
			*(vgc_bufptr++) = (vgc_stat.vs_cliprect.ymax>>8) & 0xff;
		}
	}
}

vgc_lineattr()
{
	*(vgc_bufptr++) = VGC_LINEATTR;
	*(vgc_bufptr++) = vgc_stat.vs_linewidth & 0xff;
	*(vgc_bufptr++) = (vgc_stat.vs_linewidth>>8) & 0xff;
	*(vgc_bufptr++) = 0;  /* background color */
	*(vgc_bufptr++) = vgc_stat.vs_linecolor;
	*(vgc_bufptr++) = vgc_stat.vs_linetype;
}

vgc_markattr()
{
	*(vgc_bufptr++) = VGC_MARKATTR;
	*(vgc_bufptr++) = vgc_stat.vs_marktype;
	*(vgc_bufptr++) = vgc_stat.vs_marksize & 0xff;
	*(vgc_bufptr++) = (vgc_stat.vs_marksize>>8) & 0xff;
	*(vgc_bufptr++) = 0;  /* background color */
	*(vgc_bufptr++) = vgc_stat.vs_markcolor;
}

/*
	c1 = code(*x1,*y1,rect);
	c2 = code(*x2,*y2,rect);
	if( c1&c2 ) return(1);
*/

vgc_pline(npts,points,lncontrol,wsptr)
register int npts;
Gpoint *points;
Glncontrol *lncontrol;
register Gwsstatelist *wsptr;
{
	register Gpoint *p=points;
	double tran[2][3];
	Glnbundl wsbundl;
	Glimit cliprect;
	Gilimit rect;
	char ltype,lcol;
	int lwidth,cmdcount;
	int needattr=0;
	int x1,y1,x2,y2,x3,y3;
	int c1,c2,c3;
	double tempf;

	vgc_cmdbuf[0] = VGC_MULTICOM;
	vgc_bufptr = vgc_cmdbuf + 2;

	/*
	 * update wstran, compound tran, and find net clip rectangle
	 */
	gen_udwstran(wsptr,lncontrol->lc_segtran,lncontrol->lc_cliprect,
					tran,&cliprect,&(vgc_stat.vs_ss));

	/*
	 * integerize clipping rectangle
	 */
	rect.xmin = (int)(cliprect.xmin + 0.5);
	rect.xmax = (int)(cliprect.xmax + 0.5);
	rect.ymin = (int)(cliprect.ymin + 0.5);
	rect.ymax = (int)(cliprect.ymax + 0.5);
	vgc_cliprect(&rect);

	/*
	 * update attributes
	 */
	lwidth = ((int)(wsbundl.width - 0.5)) || 0x01;
	lcol = (char)(wsbundl.color & 0xff);
	ltype = (char)(wsbundl.type & 0xff);

	/*
	 * move to first point
	 */
	tempf = (tran[0][0] * p->x) + (tran[0][1] * p->y) + tran[0][2];
	x1 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	tempf = (tran[1][0] * p->x) + (tran[1][1] * p->y) + tran[1][2];
	y1 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	p++;
	c1 = code(x1,y1,&rect);
	*(vgc_bufptr++) = VGC_MOVE;
	*(vgc_bufptr++) = (x1) & 0xff;
	*(vgc_bufptr++) = ((x1)>>8) & 0xff;
	*(vgc_bufptr++) = (y1) & 0xff;
	*(vgc_bufptr++) = ((y1)>>8) & 0xff;

	tempf = (tran[0][0] * p->x) + (tran[0][1] * p->y) + tran[0][2];
	x2 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	tempf = (tran[1][0] * p->x) + (tran[1][1] * p->y) + tran[1][2];
	y2 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	c2 = code(x2,y2,&rect);
	npts--;

	while(--npts)
	{ 
		p++;
		tempf = (tran[0][0] * p->x) + (tran[0][1] * p->y) + tran[0][2];
		x3 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
		tempf = (tran[1][0] * p->x) + (tran[1][1] * p->y) + tran[1][2];
		y3 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));

		if ((x3 == x2) && (y3 == y2))
			continue;

		/*
		 * all three are outside cliprect and x1x2 and x1x3 are both
		 * trivially clipped we can dump x2 and go on...
		 * this is a good way to decimate polygon vertices as well!
		 */
		if( c1 && (c1 & c2) && (c1 & c3))
		{
			x2 = x3;
			y2 = y3;
			c2 = c3;
			continue;
		}

		/*
		 * Is it colinear and horizontal or vertical?
		 */
		if(((y3 == y2) && (y2 == y1) && ((x3 > x2) == (x2 > x1))) ||
		   ((x3 == x2) && (x2 == x1) && ((y3 > y2) == (y2 > y1))) )
		{
			x2 = x3;
			y2 = y3;
			c2 = c3;
			continue;
		}
		*(vgc_bufptr++) = VGC_LINE;
		*(vgc_bufptr++) = (x2) & 0xff;
		*(vgc_bufptr++) = ((x2)>>8) & 0xff;
		*(vgc_bufptr++) = (y2) & 0xff;
		*(vgc_bufptr++) = ((y2)>>8) & 0xff;

		x1 = x2; y1 = y2;
		x2 = x3; y2 = y3;
		c1 = c2; c2 = c3;
	}
	*(vgc_bufptr++) = VGC_LINE;
	*(vgc_bufptr++) = (x2) & 0xff;
	*(vgc_bufptr++) = ((x2)>>8) & 0xff;
	*(vgc_bufptr++) = (y2) & 0xff;
	*(vgc_bufptr++) = ((y2)>>8) & 0xff;

	cmdcount = vgc_bufptr - vgc_cmdbuf;
	vgc_cmdbuf[1] = (cmdcount - 2) & 0xff;
    gccmdp (cmdcount,vgc_cmdbuf);

	wsptr->displaysurfempty = GNOTEMPTY;
}

/* 
 * Default the color lookup table
 */

/* Color indices */
#define	BLACK		0
#define	RED			1
#define YELLOW		2
#define GREEN		3
#define CYAN		4
#define BLUE		5
#define MAGENTA		6
#define WHITE		7
#define DKGRAY		8
#define OFFWHITE	9
#define GRAY		10
#define ORANGE		11
#define BROWN		12
#define PURPLE		13
#define DKGREEN		14
#define BLGREEN		15
 
static struct{
	char c_index;
	int  c_red;
	int  c_green;
	int  c_blue;
} defcolors[] = {
    BLACK,		0,		0,		0,
    RED,		1000,	0,		0,
    YELLOW,		1000,	1000,	0,
    GREEN,		0,		1000,	0,
    CYAN,		0,		1000,	1000,
    BLUE,		0,		0,		1000,
    MAGENTA,	1000,	0,		1000,
    WHITE,		1000,	1000,	1000,
    DKGRAY,		150,	150,	150,
    OFFWHITE,	850,	850,	850,
    GRAY,		425,	425,	425,
    ORANGE,		1000,	500,	0,
    BROWN,		650,	350,	100,
    PURPLE,		600,	0,		900,
    DKGREEN,	0,		500,	100,
    BLGREEN,	0,		1000,	600
};

vgc_dfcolortable()
{
    register int j = 16;
	int cmdcount;

	vgc_cmdbuf[0] = VGC_MULTICOM;
	vgc_bufptr = vgc_cmdbuf+2;
 
    while (j--)
	{
		*(vgc_bufptr++) = VGC_SETCOLOR;
		*(vgc_bufptr++) = defcolors[j].c_index;
		*(vgc_bufptr++) = defcolors[j].c_red & 0xff;
		*(vgc_bufptr++) = (defcolors[j].c_red >> 8) & 0xff;
		*(vgc_bufptr++) = defcolors[j].c_green & 0xff;
		*(vgc_bufptr++) = (defcolors[j].c_green >> 8) & 0xff;
		*(vgc_bufptr++) = defcolors[j].c_blue & 0xff;
		*(vgc_bufptr++) = (defcolors[j].c_blue >> 8) & 0xff;
    }
	cmdcount = vgc_bufptr - vgc_cmdbuf;
	vgc_cmdbuf[1] = (cmdcount - 2) & 0xff;
    gccmdp (cmdcount,vgc_cmdbuf);
} 
