#include <stdio.h>

#ifndef DOS
#include <sgtty.h>
#endif

#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "wstable.h"
#include "metafile.h"

#include "tek410x.h"

char *malloc();
extern Gdevsw _gdevsw[];

tek410X_open(wsptr)
register Gwsstatelist *wsptr;
{
#ifndef DOS
	struct sgttyb ttystat;
	int fd;
#endif
	Gdevsw *dev;

	wsptr->scratchpad = malloc( sizeof(struct tek410Xcontrol));
	dev = _gdevsw + gmajordev(wsptr->type);

#ifndef DOS
	fd = fileno(wsptr->infile);
	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags &= (~ECHO);
	ioctl(fd,TIOCSETP,&ttystat);
#endif

	/*
	 * Set the graphics window.
	 */

	tek410X_code(TEK,wsptr);
	putc(ESC,wsptr->outfile);
	putc('R',wsptr->outfile);
	putc('W',wsptr->outfile);
	tek410X_xypack( 0, 0, wsptr );
	tek410X_xypack( (int)(wsptr->curviewport.xmax), 
				(int)(wsptr->curviewport.ymax), wsptr );

	/*
	 * Set line style to default line.
	 * Set color to default color (usually white, but controlled 
	 *  by color table).
	 */
	tek410X_lnstyle(0,wsptr);
	tek410X_lncol(1,wsptr);
	tek410X_txcol(1,wsptr);
		
	(*(dev->wscontrol))(CLEAR,wsptr);
	return;
}

/*
 * Close 410X terminal
 * and return it to ANSI mode
 */
tek410X_close(wsptr)
register Gwsstatelist *wsptr;
{
#ifndef DOS
	struct sgttyb ttystat;
	register int fd;
#endif

	tek410X_mode(ALPHA,wsptr);
	putc(ESC,wsptr->outfile);
	putc('L',wsptr->outfile);
	putc('V',wsptr->outfile);
	putc('1',wsptr->outfile);
	tek410X_code(ANSI,wsptr);

#ifndef DOS
	fd = fileno(wsptr->infile);
	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags |= (ECHO);
	ttystat.sg_flags &= (~CBREAK);
	ioctl(fd,TIOCSETP,&ttystat);
#endif

	fflush(wsptr->outfile);
}

/*
 * draw line segment
 */

tek410X_vector(x1,y1,x2,y2,wsptr)
int x1,y1,x2,y2;
Gwsstatelist *wsptr;
{
	register struct tek410Xcontrol *tc =
			(struct tek410Xcontrol *)(wsptr->scratchpad);
	register int dx1,dx2,dy1,dy2;

	if (  (tc->mode != VECTOR) || tc->lost)
	{
		tek410X_mode(VECTOR,wsptr);
		tek410X_xypack(x1,y1,wsptr);
		tek410X_xypack(x2,y2,wsptr);
		tc->lastx = x2; tc->lasty = y2;
		tc->lost=0;
		return;
	}
	else if ((tc->lastx != x1) || (tc->lasty != y1))
	{
		if((tc->lastx == x2) && (tc->lasty == y2))
		{
			x2 = x1; y2 = y1;
		}
		else
		{
			dx1 = tc->lastx - x1;
			dy1 = tc->lasty - y1;
			if( dx1 < 0) dx1 = -dx1;
			if( dy1 < 0) dy1 = -dy1;
			dx2 = tc->lastx - x2;
			dy2 = tc->lasty - y2;
			if( dx2 < 0) dx2 = -dx2;
			if( dy2 < 0) dy2 = -dy2;
			if((dx2+dy2) < (dx1+dy1))
			{
				dx1 = x1;
				dy1 = y1;
				x1 = x2;
				y1 = y2;
				x2 = dx1;
				y2 = dy1;
			}
			tek410X_mode(VECTOR,wsptr);
			tek410X_xypack(x1,y1,wsptr);
		}
	}
	tek410X_xypack (x2,y2,wsptr);
	tc->lastx = x2; tc->lasty = y2;
}

/*
 * set code that the terminal interprets
 */
tek410X_code(code,wsptr)
register int code;
register Gwsstatelist *wsptr;
{
	register struct tek410Xcontrol *tc =
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	if((code >= TEK) && (code <= VT52))
	{
		putc(ESC,wsptr->outfile);
		putc('%',wsptr->outfile);
		putc('!',wsptr->outfile);

		switch(code)
		{
		case TEK:
			putc('0',wsptr->outfile);
			break;
		case ANSI:
			putc('1',wsptr->outfile);
			break;
		case EDIT:
			putc('2',wsptr->outfile);
			break;
		case VT52:
			putc('3',wsptr->outfile);
			break;
		}
		tc->code = code;
	}
}


/*
 * set and record new Tek410X mode
 *
 * N.B. we always issue a change to VECTOR when asked since this
 *		is how a move is implemented when we are in VECTOR mode
 *		already
 */
tek410X_mode(mode,wsptr)
register int mode;
register Gwsstatelist *wsptr;
{
	register struct tek410Xcontrol *tc =
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	if(tc->code != TEK)
	{
		putc(ESC,wsptr->outfile);
		putc('%',wsptr->outfile);
		putc('!',wsptr->outfile);
		putc('0',wsptr->outfile);
	}

	switch(mode)
	{
	case VECTOR: 
		if(tc->mode == MARKERS)
			putc(US,wsptr->outfile);
		putc(GS,wsptr->outfile);
		tc->mode = VECTOR;
		tc->lost = 1;
		break;
	case ALPHA: 
		if(tc->mode != ALPHA)
		{
			tc->lost = 1;
			putc(US,wsptr->outfile);
			tc->mode = ALPHA;
		}
		break;
	case MARKERS: 
		if(tc->mode != MARKERS)
		{
			tc->lost = 1;
			putc(FS,wsptr->outfile);
			tc->mode = MARKERS;
		}
		break;
	}
}


tek410X_lncol(color,wsptr)
register int color;
register Gwsstatelist *wsptr;
{
	register struct tek410Xcontrol *tc =
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	if(tc->lncolor == color)
		return;

	putc(ESC,wsptr->outfile);
	putc('M',wsptr->outfile);
	putc('L',wsptr->outfile);
	tek410X_ipack(color,wsptr);
	tc->lncolor = color;
}


tek410X_lnstyle(style,wsptr)
register int style;
register Gwsstatelist *wsptr;
{
	register struct tek410Xcontrol *tc =
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	if(tc->lnstyle == style)
		return;

	putc(ESC,wsptr->outfile);
	putc('M',wsptr->outfile);
	putc('V',wsptr->outfile);
	tek410X_ipack(style,wsptr);
	tc->lnstyle = style;
}

tek410X_mktype(type,wsptr)
register int type;
register Gwsstatelist *wsptr;
{
	register struct tek410Xcontrol *tc =
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	if(tc->mktype == type)
		return;

	putc(ESC,wsptr->outfile);
	putc('M',wsptr->outfile);
	putc('M',wsptr->outfile);
	tek410X_ipack(type,wsptr);
	tc->mktype = type;
}

tek410X_txcol(color,wsptr)
register int color;
register Gwsstatelist *wsptr;
{
	register struct tek410Xcontrol *tc =
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	if(tc->txcolor == color)
		return;

	putc(ESC,wsptr->outfile);
	putc('M',wsptr->outfile);
	putc('T',wsptr->outfile);
	tek410X_ipack(color,wsptr);
	tc->txcolor = color;
}

tek410X_txprec(prec,wsptr)
register int prec;
register Gwsstatelist *wsptr;
{
	register struct tek410Xcontrol *tc =
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	putc(ESC,wsptr->outfile);
	putc('M',wsptr->outfile);
	putc('Q',wsptr->outfile);
	switch(prec)
	{
	case GSTRING:
		tek410X_ipack(1,wsptr);
		break;
	case GSTROKE:
		tek410X_ipack(2,wsptr);
		break;
	}
}

tek410X_txsz(width,height,spacing,wsptr)
register int width,height,spacing;
register Gwsstatelist *wsptr;
{
	register struct tek410Xcontrol *tc =
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	putc(ESC,wsptr->outfile);
	putc('M',wsptr->outfile);
	putc('C',wsptr->outfile);
	tek410X_ipack(width,wsptr);
	tek410X_ipack(height,wsptr);
	tek410X_ipack(spacing,wsptr);
}


/*
 * Tek 410X x,y coordinate packing.
 * All x,y coordinates passed to the Tek are in this format:
 * you need not be in Vector Mode or Marker Mode to use it.
 * There are 12 significant bits per coordinate.
 * If all coordinates are multiples of 4, no 'extra' byte
 * will ever be sent. Previously-encoded positions are saved in
 * ohiy, oloy, etc. in order to abbreviate the number of
 * bytes sent out. This routine assumes pltout is open.
 */

tek410X_xypack(x,y,wsptr)
int x,y;
Gwsstatelist *wsptr;
{
	register int hiy,extra,loy,hix,lox;
	register struct tek410Xcontrol *tc =
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	/*
	 * Encode the new position.
	 */
	hiy = 0040 | ((y >> 7) & 037);
	loy = 0140 | ((y >> 2) & 037);
	hix = 0040 | ((x >> 7) & 037);
	lox = 0100 | ((x >> 2) & 037);
	extra = 0140 | ((y & 03) << 2) | (x & 03);

	/*
	 * Only print what's necessary, according to Tek rules.
	 */
	if((hiy != tc->ohiy) || tc->lost)
		putc(hiy,wsptr->outfile);
	if((extra != tc->oextra) || tc->lost)
		putc(extra,wsptr->outfile);
	if((loy != tc->oloy) || (extra != tc->oextra) || (hix != tc->ohix) ||
		tc->lost )
		putc(loy,wsptr->outfile);
	if((hix != tc->ohix) || tc->lost)
		putc(hix,wsptr->outfile);
	putc(lox,wsptr->outfile);

	/*
	 * Remember these for next time.
	 */
	tc->ohiy = hiy;
	tc->oextra = extra;
	tc->oloy = loy;
	tc->ohix = hix;
	tc->lost = 0;
}

/*
 * Issue a packed integer. From one to three bytes sent.
 */
tek410X_ipack(i,wsptr)
register int i;
register Gwsstatelist *wsptr;
{
	int ihi,imd,ilo;

	if (i < 0) {
		i = -i;
		ilo = 040;
	} else
		ilo = 060;

	ihi = 0100 | ((i >> 10) & 037);
	imd = 0100 | ((i >> 4) & 077);
	ilo |= (i & 017);

	if (ihi != 0100) putc(ihi,wsptr->outfile);
	if (imd != 0100) putc(imd,wsptr->outfile);
	putc(ilo,wsptr->outfile);
}

tek410X_point(x,y,wsptr)
register int x,y;
Gwsstatelist *wsptr;
{
	register struct tek410Xcontrol *tc =
			(struct tek410Xcontrol *)(wsptr->scratchpad);

	if( tc->mktype != 0)
		tek410X_mktype(0,wsptr);

	if (  (tc->mode != MARKERS) || tc->lost)
	{
		tek410X_mode(MARKERS,wsptr);
	}
	tek410X_xypack(x,y,wsptr);
	tc->lastx = x; tc->lasty = y;
}
