#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "wstable.h"
#include "metafile.h"
#include "extern.h"
#include "tek410x.h"

Gwstable tek4107_wstable={
	GOUTIN,
	{ GDC_OTHER, {639., 479.}, {640, 480} }
};

#define CHARWIDTH	7
#define CHARHEIGHT	9
#define BOXWIDTH	9
#define BOXHEIGHT	13

double sqrt();

tek4107_text(pos,string,txcontrol,wsptr)
Gpoint *pos;
char string[];
Gtxcontrol *txcontrol;
register Gwsstatelist *wsptr;
{
	char *sptr,*sptr2;
	int nchar;
	int xp,yp,x;
	int iheight,htscl;
	int cw,ch,bw,bh;
	int ixmin,ixmax,iymin,iymax;
	double tempf,height;
	Gpoint devup,devpath;
	Gtxbundl txattr;
	Glimit netcliprect;
	double nettran[2][3];

	/*
	 * update wstran, compound nettran, and find net clip rectangle
	 */
	gen_udwstran(wsptr,txcontrol->tc_segtran,txcontrol->tc_cliprect,
					nettran,&netcliprect);

	ixmin = (int)(netcliprect.xmin + 0.5);
	ixmax = (int)(netcliprect.xmax + 0.5);
	iymin = (int)(netcliprect.ymin + 0.5);
	iymax = (int)(netcliprect.ymax + 0.5);

	/*
	 * transform position to integer coordinates.
	 */
	tempf = (nettran[0][0] * pos->x) + (nettran[0][1] * pos->y)
			+ nettran[0][2];
	xp = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	tempf = (nettran[1][0] * pos->x) + (nettran[1][1] * pos->y)
			+ nettran[1][2];
	yp = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));

	devup.x = (nettran[0][0] * txcontrol->tc_up.x) +
			  (nettran[0][1] * txcontrol->tc_up.y);
	devup.y = (nettran[1][0] * txcontrol->tc_up.x) +
			  (nettran[1][1] * txcontrol->tc_up.y);
	devpath.x = (nettran[0][0] * txcontrol->tc_path.x) +
				(nettran[0][1] * txcontrol->tc_path.y);
	devpath.y = (nettran[1][0] * txcontrol->tc_path.x) +
				(nettran[1][1] * txcontrol->tc_path.y);

	gen_wstxattr(wsptr,txcontrol,&txattr);
		
	/*
	 * branch on text precision
	 */
	if( txattr.fp.prec == GSTRING )
	{
		tek410X_txprec(GSTRING,wsptr);
		tek410X_txcol(txattr.color,wsptr);

		/*
		 * get height, round to nearest in pixels
		 */
		height = sqrt((devup.x * devup.x) + (devup.y * devup.y));
		iheight = (int)( height/9.0 + 0.5) * 9;
		if(iheight < 9) iheight = 9;
		htscl = iheight/9;
		cw = htscl * CHARWIDTH;
		ch = htscl * CHARHEIGHT;
		bw = htscl * BOXWIDTH;
		bh = htscl * BOXHEIGHT;
		tek410X_txsz(0,iheight,0,wsptr);

		/*
		 * count characters to simulate text alignment
		 */
		nchar = 0;
		switch(txcontrol->tc_align.hor)
		{
		case GTH_CENTER:
			nchar = strlen(string);
			xp -= ((nchar-1) * bw  + cw)>>1;
			break;
		case GTH_RIGHT:
			nchar = strlen(string);
			xp -= ((nchar-1) * bw  + cw);
			break;
		default:
			break;
		}

		switch(txcontrol->tc_align.ver)
		{
		case GTV_TOP:
			yp -= 1;
		case GTV_CAP:
			yp -= ch;
			break;
		case GTV_HALF:
			yp -= ch >> 1;
			break;
		case GTV_BOTTOM:
			yp += 2;
			break;
		default:
			break;
		}

		if( ( yp > iymax - ch) || ( yp < iymin))
				return(0);

		sptr = string;
		nchar = 0;
		while ( xp < ixmin)
		{
			xp += bw;
			sptr++;
			if(!(*sptr)) return(0);
		}
		x = xp + cw;
		sptr2 = sptr;
		while( *sptr2 && ( x <= ixmax))
		{
			nchar++;
			sptr2++;
			x += bw;
		}
		if(nchar == 0) return(0);
		xp -= ((bw - cw)>>1);
		if(xp < 0) xp=0;

		tek410X_mode(VECTOR,wsptr);
		tek410X_xypack(xp,yp,wsptr);
		tek410X_mode(ALPHA,wsptr);
		putc(ESC,wsptr->outfile);
		putc('L',wsptr->outfile);
		putc('T',wsptr->outfile);
		tek410X_ipack(nchar,wsptr);
		while(nchar--)
		{
			putc(*sptr,wsptr->outfile);
			sptr++;
		}
	}
	else
	{
	}

	fflush(wsptr->outfile);
	wsptr->displaysurfempty = GNOTEMPTY;
	return(0);
}

tek4107_wscontrol(command,wsptr,arg)
int command;
Gwsstatelist *wsptr;
char *arg;
{
	register struct tek410Xcontrol *tc = 
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	switch(command)
	{
	case CLEAR:
		tek410X_mode(ALPHA,wsptr);

		/*
		 * make sure dialog is invisible
		 */
		putc(ESC, wsptr->outfile);
		putc('L', wsptr->outfile);
		putc('V', wsptr->outfile);
		putc('0', wsptr->outfile);

		/*
		 * set fixup level to 0
		 */
		putc(ESC, wsptr->outfile);
		putc('R', wsptr->outfile);
		putc('F', wsptr->outfile);
		putc('0', wsptr->outfile);
		
		/*
		 * delete all segments
		 */
		putc(ESC, wsptr->outfile);
		putc('S', wsptr->outfile);
		putc('K', wsptr->outfile);
		putc('!', wsptr->outfile);
		wsptr->displaysurfempty = GEMPTY;

		/* fall through */
	case UPDATE:
		tek410X_mode(ALPHA,wsptr);
		putc(ESC, wsptr->outfile);
		putc(FF, wsptr->outfile);
		tc->messagecount = 0;
		tc->lastx = -1;
		tc->lasty = -1;
		putc(ESC, wsptr->outfile);
		putc('R', wsptr->outfile);
		putc('F', wsptr->outfile);
		putc('6', wsptr->outfile);
		fflush(wsptr->outfile);
		break;
	case REDRAW_ALL_SEGMENTS_ON:
	case SET_DEFFERAL_STATE_OF:
	case SEND_MESSAGE_TO:
	case SEND_ESCAPE_TO:
		break;
	}
	return;
}

tek4107_segcontrol(command,wsptr,seg)
int command;
Gwsstatelist *wsptr;
int seg;
{
	register struct tek410Xcontrol *tc = 
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	switch(command)
	{
	case CREATE:
		tek410X_mode(ALPHA,wsptr);
		putc(ESC,wsptr->outfile);
		putc('S',wsptr->outfile);
		putc('O',wsptr->outfile);
		tek410X_ipack(seg,wsptr);
		break;
	case CLOSE:
		tek410X_mode(ALPHA,wsptr);
		putc(ESC,wsptr->outfile);
		putc('S',wsptr->outfile);
		putc('C',wsptr->outfile);
		break;
	case DELETE:
		tek410X_mode(ALPHA,wsptr);
		putc(ESC,wsptr->outfile);
		putc('S',wsptr->outfile);
		putc('K',wsptr->outfile);
		tek410X_ipack(seg,wsptr);
		break;
	case RENAME:
	default:
		break;
	}
	return;
}

tek4107_segattr(command,wsptr,seg,arg)
int command;
Gwsstatelist *wsptr;
int seg;
char *arg;
{
	register struct tek410Xcontrol *tc = 
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	switch(command)
	{
	case TRANSFORMATION:
		break;
	case VISIBILITY:
		tek410X_mode(ALPHA,wsptr);
		putc(ESC,wsptr->outfile);
		putc('S',wsptr->outfile);
		putc('V',wsptr->outfile);
		tek410X_ipack(seg,wsptr);
		tek410X_ipack((*(int *)arg),wsptr);
		break;
	case HIGHLIGHTING:
		break;
	case PRIORITY:
		break;
	case DETECTABILITY:
		break;
	}
	return;
}
