#include <stdio.h>

#ifndef DOS
#include <sgtty.h>
#endif

#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "metafile.h"
#include "wstable.h"
#include "metafile.h"
#include "extern.h"

extern Gwstable *_wstable[];

#include "tek410x.h"

Gwstable tek4105_wstable={
	GOUTIN,
	{ GDC_OTHER, {479., 359.}, {480, 360} }
};


tek4105_wscontrol(command,wsptr,arg)
int command;
Gwsstatelist *wsptr;
char *arg;
{
	register struct tek410Xcontrol *tc = 
						(struct tek410Xcontrol *)(wsptr->scratchpad);

	switch(command)
	{
	case CLEAR:
		tek410X_mode(ALPHA,wsptr);
		putc(ESC, wsptr->outfile);
		putc('L', wsptr->outfile);
		putc('V', wsptr->outfile);
		putc('0', wsptr->outfile);
		putc(ESC, wsptr->outfile);
		putc(FF, wsptr->outfile);
		tc->messagecount = 0;
		tc->lastx = -1;
		tc->lasty = -1;
		wsptr->displaysurfempty = GEMPTY;
	case UPDATE:
		fflush(wsptr->outfile);
		break;
	case REDRAW_ALL_SEGMENTS_ON:
	case SET_DEFFERAL_STATE_OF:
	case SEND_MESSAGE_TO:
	case SEND_ESCAPE_TO:
		break;
	}
	return;
}

tek4105_pline(npts,points,lncontrol,wsptr)
register int npts;
Gpoint *points;
Glncontrol *lncontrol;
register Gwsstatelist *wsptr;
{
	int fat,style;
	Glnbundl lnattr;
	double nettran[2][3];
	Glimit netcliprect;

	/*
	 * update wstran, compound nettran, and find net clip rectangle
	 */
	gen_udwstran(wsptr,lncontrol->lc_segtran,lncontrol->lc_cliprect,
						nettran,&netcliprect);

	/*
	 * update attributes
	 */
	gen_wslnattr(wsptr,lncontrol,&lnattr);

	tek410X_lncol(lnattr.color, wsptr );
	fat = ((int)(lnattr.width+0.5) - 1)>>1;

	if(fat==0)
	{
		switch(lnattr.type)
		{
		case 2:
			tek410X_lnstyle(4,wsptr);
			break;
		case 3:
			tek410X_lnstyle(1,wsptr);
			break;
		case 4:
			tek410X_lnstyle(2,wsptr);
			break;
		case 5:
			tek410X_lnstyle(5,wsptr);
			break;
		case 6:
			tek410X_lnstyle(6,wsptr);
			break;
		case 7:
			tek410X_lnstyle(3,wsptr);
			break;
		default:
			tek410X_lnstyle(0,wsptr);
			break;
		}
	}

	style=0;
	gen_pline(npts,points,nettran,&netcliprect,fat,style,wsptr);

	/*
	 * reset solid line
	 */
	if( (lnattr.type > 1) && (fat == 0))
		tek410X_lnstyle(0,wsptr);
	fflush(wsptr->outfile);
	wsptr->displaysurfempty = GNOTEMPTY;
}

#define NOMSIZE 5

tek4105_pmark(npts,points,mkcontrol,wsptr)
register int npts;
Gpoint *points;
Gmkcontrol *mkcontrol;
register Gwsstatelist *wsptr;
{
	Gmkbundl mkattr;
	double nettran[2][3];
	Glimit netcliprect;
	int size;

	/*
	 * update wstran, compound nettran, and find net clip rectangle
	 */
	gen_udwstran(wsptr,mkcontrol->mc_segtran,mkcontrol->mc_cliprect,
					nettran,&netcliprect);

	/*
	 * update attributes
	 */
	gen_wsmkattr(wsptr,mkcontrol,&mkattr);
	size = mkattr.size * NOMSIZE;
	tek410X_lncol(mkattr.color, wsptr);

	gen_pmark(npts,points,nettran,&netcliprect,mkattr.type,size,wsptr);

	fflush(wsptr->outfile);
	wsptr->displaysurfempty = GNOTEMPTY;
}

#define CHARWIDTH	5
#define CHARHEIGHT	7
#define BOXWIDTH	7
#define BOXHEIGHT	10

double sqrt();

tek4105_text(pos,string,txcontrol,wsptr)
Gpoint *pos;
char string[];
Gtxcontrol *txcontrol;
register Gwsstatelist *wsptr;
{
	char *sptr,*sptr2;
	int nchar;
	int xp,yp,x;
	int iheight,htscl;
	int cw,ch,bw,bh;
	int ixmin,ixmax,iymin,iymax;
	double tempf,height;
	Gpoint devup,devpath;
	Gtxbundl txattr;
	Glimit netcliprect;
	double nettran[2][3];

	/*
	 * update wstran, compound nettran, and find net clip rectangle
	 */
	gen_udwstran(wsptr,txcontrol->tc_segtran,txcontrol->tc_cliprect,
					nettran,&netcliprect);

	ixmin = (int)(netcliprect.xmin + 0.5);
	ixmax = (int)(netcliprect.xmax + 0.5);
	iymin = (int)(netcliprect.ymin + 0.5);
	iymax = (int)(netcliprect.ymax + 0.5);

	/*
	 * transform position to integer coordinates.
	 */
	tempf = (nettran[0][0] * pos->x) + (nettran[0][1] * pos->y)
			+ nettran[0][2];
	xp = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	tempf = (nettran[1][0] * pos->x) + (nettran[1][1] * pos->y)
			+ nettran[1][2];
	yp = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));

	devup.x = (nettran[0][0] * txcontrol->tc_up.x) +
			  (nettran[0][1] * txcontrol->tc_up.y);
	devup.y = (nettran[1][0] * txcontrol->tc_up.x) +
			  (nettran[1][1] * txcontrol->tc_up.y);
	devpath.x = (nettran[0][0] * txcontrol->tc_path.x) +
				(nettran[0][1] * txcontrol->tc_path.y);
	devpath.y = (nettran[1][0] * txcontrol->tc_path.x) +
				(nettran[1][1] * txcontrol->tc_path.y);
		
	gen_wstxattr(wsptr,txcontrol,&txattr);

	/*
	 * branch on text precision
	 */
	if( txattr.fp.prec == GSTRING )
	{

		tek410X_txcol(txattr.color,wsptr);

		/*
		 * get height, round to nearest in pixels
		 */
		height = sqrt((devup.x * devup.x) + (devup.y * devup.y));
		iheight = (int)( height/7.0 + 0.5) * 7;
		if(iheight < 7) iheight = 7;
		htscl = iheight/7;
		cw = htscl * CHARWIDTH;
		ch = htscl * CHARHEIGHT;
		bw = htscl * BOXWIDTH;
		bh = htscl * BOXHEIGHT;
		tek410X_txsz(0,iheight,0,wsptr);

		/*
		 * count characters to simulate text alignment
		 */
		nchar = 0;
		switch(txcontrol->tc_align.hor)
		{
		case GTH_CENTER:
			nchar = strlen(string);
			xp -= ((nchar-1) * bw  + cw)>>1;
			break;
		case GTH_RIGHT:
			nchar = strlen(string);
			xp -= ((nchar-1) * bw  + cw);
			break;
		default:
			break;
		}

		switch(txcontrol->tc_align.ver)
		{
		case GTV_TOP:
			yp -= htscl;
		case GTV_CAP:
			yp -= ch;
			break;
		case GTV_HALF:
			yp -= ch >> 1;
			break;
		case GTV_BOTTOM:
			yp += 2;
			break;
		default:
			break;
		}

		if( ( yp > iymax - ch) || ( yp < iymin))
				return(0);

		sptr = string;
		nchar = 0;
		while ( xp < ixmin)
		{
			xp += bw;
			sptr++;
			if(!(*sptr)) return(0);
		}
		x = xp + cw;
		sptr2 = sptr;
		while( *sptr2 && ( x <= ixmax))
		{
			nchar++;
			sptr2++;
			x += bw;
		}
		if(nchar == 0) return(0);
		xp -= ((bw - cw)>>1);
		if(xp < 0) xp=0;

		tek410X_mode(VECTOR,wsptr);
		tek410X_xypack(xp,yp,wsptr);
		tek410X_mode(ALPHA,wsptr);
		putc(ESC,wsptr->outfile);
		putc('L',wsptr->outfile);
		putc('T',wsptr->outfile);
		tek410X_ipack(nchar,wsptr);
		while(nchar--)
		{
			putc(*sptr,wsptr->outfile);
			sptr++;
		}
	}
	else
	{
	}

	fflush(wsptr->outfile);
	wsptr->displaysurfempty = GNOTEMPTY;
	return(0);
}


tek4105_loc(wsptr,locdev,response)
register Gwsstatelist *wsptr;
int locdev;
Gqloc *response;
{
	register struct tek410Xcontrol *tc =
			(struct tek410Xcontrol *)(wsptr->scratchpad);
	register Gwstable *wsd = _wstable[(wsptr->type)];
	int xp,yp,fd;
	char string[10];
#ifndef DOS
	struct sgttyb ttystat;
#endif

	/*
	 * expand window due to 10 bit report length
	 */
	putc(ESC,wsptr->outfile);
	putc('R',wsptr->outfile);
	putc('W',wsptr->outfile);
	tek410X_xypack( 0, 0, wsptr );
	tek410X_xypack( (int)(4 * wsd->dspsize.device.x),
					(int)(4 * wsd->dspsize.device.y), wsptr );

	/*
	 * set initial cursor position
	 */
	if( (response->loc.position.x < wsptr->curwindow.xmin)||
		(response->loc.position.x > wsptr->curwindow.xmax))
			response->loc.position.x = (wsptr->curwindow.xmax
										+ wsptr->curwindow.xmin)/2.;
	if( (response->loc.position.y < wsptr->curwindow.ymin)||
		(response->loc.position.y > wsptr->curwindow.ymax))
			response->loc.position.y = (wsptr->curwindow.ymax
										+ wsptr->curwindow.ymin)/2.;
	xp = (response->loc.position.x * wsptr->scale) + wsptr->xshift + 0.5;
	yp = (response->loc.position.y * wsptr->scale) + wsptr->yshift + 0.5;
	putc(ESC,wsptr->outfile);
	putc('S',wsptr->outfile);
	putc('X',wsptr->outfile);
	tek410X_ipack(0,wsptr);
	tek410X_xypack( (4 * xp), (4 * yp), wsptr );

#ifndef DOS
	fd = fileno(wsptr->infile);
	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags |= (ECHO|CBREAK);
	ioctl(fd,TIOCSETP,&ttystat);
	ioctl(fd,TIOCFLUSH,&ttystat);
#endif

	putc(GS,wsptr->outfile);
	putc(ESC,wsptr->outfile);
	putc(SUB,wsptr->outfile);
	fflush(wsptr->outfile);

	fread(string,1,6,wsptr->infile);

	tc->mode=ALPHA;
	tc->lost=1;

#ifndef DOS
	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags &= (~ECHO);
	ttystat.sg_flags &= (~CBREAK);
	ioctl(fd,TIOCSETP,&ttystat);
#endif

	/*
	 * shrink window back to direct pixel size
	 */
	putc(ESC,wsptr->outfile);
	putc('R',wsptr->outfile);
	putc('W',wsptr->outfile);
	tek410X_xypack( 0, 0, wsptr );
	tek410X_xypack( (int)(wsd->dspsize.device.x),
					(int)(wsd->dspsize.device.y), wsptr );

	if(string[0] == '\033')
	{
		response->status = GNONE;
		return(0);
	}

	xp = (((string[1] & 037) << 5) | (string[2] & 037));
	yp = (((string[3] & 037) << 5) | (string[4] & 037));
	response->loc.position.x = ((double)(xp) - wsptr->xshift)/(wsptr->scale);
	response->loc.position.y = ((double)(yp) - wsptr->yshift)/(wsptr->scale);

	if( (response->loc.position.x < wsptr->curwindow.xmin)||
		(response->loc.position.x > wsptr->curwindow.xmax)||
		(response->loc.position.y < wsptr->curwindow.ymin)||
		(response->loc.position.y > wsptr->curwindow.ymax))
	{
		response->loc.position.x = 0.;
		response->loc.position.y = 0.;
		response->status = GNONE;
	}
	else
	{
		response->status = GOK;
	}
	return(0);
}
