#include <stdio.h>
#include "../../../include/gks.h"
#include "../../../include/params.h"
#include "../../../include/driver.h"
#include "../../../include/wsstate.h"
#include "../../../include/metafile.h"
#include "../tek4100.h"

t07_wscntrl(command,wsptr,arg)
int command;
Gwsstatelist *wsptr;
char *arg;
{
	register struct tek4100control *tc = 
						(struct tek4100control *)(wsptr->scratchpad);

	switch(command)
	{
	case CLEAR:
		t41_mode(ALPHA,wsptr);

		/*
		 * make sure dialog is invisible
		 */
		putc(ESC, wsptr->outfile);
		putc('L', wsptr->outfile);
		putc('V', wsptr->outfile);
		putc('0', wsptr->outfile);

		/*
		 * set fixup level to 0
		 */
		putc(ESC, wsptr->outfile);
		putc('R', wsptr->outfile);
		putc('F', wsptr->outfile);
		putc('0', wsptr->outfile);
		
		/*
		 * delete all segments
		 */
		putc(ESC, wsptr->outfile);
		putc('S', wsptr->outfile);
		putc('K', wsptr->outfile);
		putc('!', wsptr->outfile);
		wsptr->displaysurfempty = GEMPTY;

		/* fall through */
	case UPDATE:
		t41_mode(ALPHA,wsptr);
		putc(ESC, wsptr->outfile);
		putc(FF, wsptr->outfile);
		tc->messagecount = 0;
		tc->lastx = -1;
		tc->lasty = -1;
		putc(ESC, wsptr->outfile);
		putc('R', wsptr->outfile);
		putc('F', wsptr->outfile);
		putc('6', wsptr->outfile);
		fflush(wsptr->outfile);
		break;
	case REDRAW_ALL_SEGMENTS_ON:
	case SET_DEFFERAL_STATE_OF:
	case SEND_MESSAGE_TO:
	case SEND_ESCAPE_TO:
		break;
	}
	return;
}
