#include <stdio.h>
#include "../../../include/gks.h"
#include "../../../include/params.h"
#include "../../../include/driver.h"
#include "../../../include/wsstate.h"
#include "../tek4100.h"

Gwstran gen_wstran();

t07_wstran(wsptr)
register Gwsstatelist *wsptr;
{
	Gwstran wstran;
	register struct tek4100control *tc =
						(struct tek4100control *)(wsptr->scratchpad);

	wsptr->curwindow = wsptr->reqwindow;
	wsptr->curviewport = wsptr->reqviewport;

	wstran = gen_wstran(wsptr);

	/*
	 * output new window
	 */
	t41_mode(ALPHA,wsptr);
	putc(ESC,wsptr->outfile);
	putc('R',wsptr->outfile);
	putc('W',wsptr->outfile);
	t41_xypack( (int)((wsptr->curwindow.ll.x * 4095.)+0.5),
				(int)((wsptr->curwindow.ll.y * 4095.)+0.5), wsptr );
	t41_xypack( (int)((wsptr->curwindow.ur.x * 4095.)+0.5),
				(int)((wsptr->curwindow.ur.y * 4095.)+0.5), wsptr );
	/*
	 * output corresponding viewport
	 */
	putc(ESC,wsptr->outfile);
	putc('R',wsptr->outfile);
	putc('V',wsptr->outfile);
	t41_xypack( (int)(wsptr->curviewport.ll.x + 0.5),
				(int)(wsptr->curviewport.ll.y + 0.5), wsptr );
	t41_xypack((int)(wsptr->curwindow.ur.x * wstran.scale
				+ wstran.xshift+ 0.5), (int)(wsptr->curwindow.ur.y
				* wstran.scale + wstran.yshift+ 0.5), wsptr);

	wsptr->tranudpending = GNOTPENDING;
	return;
}
