#include <stdio.h>
#include "../../../include/gks.h"
#include "../../../include/params.h"
#include "../../../include/driver.h"
#include "../../../include/wsstate.h"
#include "../../../include/gksstate.h"
#include "../../../include/extern.h"
#include "../tek4100.h"

#define CHARWIDTH	7
#define CHARHEIGHT	9
#define BOXWIDTH	9
#define BOXHEIGHT	13

double sqrt();

t07_text(pos,up,path,align,string,segtran,wsptr)
Gpoint *pos,*up,*path;
Gtxalign *align;
char string[];
float segtran[2][3];
register Gwsstatelist *wsptr;
{
	register struct tek4100control *tc =
					(struct tek4100control *)wsptr->scratchpad;
	char *sptr,*sptr2;
	int nchar;
	int xp,yp,x;
	int iheight,htscl;
	int font,prec;
	int cw,ch,bw,bh;
	int ixmin,ixmax,iymin,iymax;
	double tempf,height;
	Gpoint devup,devpath;
	Glimit cliprect;
	float nettran[2][3];

	/*
	 * update wstran, compound nettran, and find net clip rectangle
	 */
	gen_udwstran(segtran,wsptr,&(tc->ss),&cliprect,nettran);
	ixmin = (int)(cliprect.xmin + 0.5);
	ixmax = (int)(cliprect.xmax + 0.5);
	iymin = (int)(cliprect.ymin + 0.5);
	iymax = (int)(cliprect.ymax + 0.5);

	/*
	 * transform position to integer coordinates.
	 */
	tempf = (nettran[0][0] * pos->x) + (nettran[0][1] * pos->y)
			+ nettran[0][2];
	xp = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	tempf = (nettran[1][0] * pos->x) + (nettran[1][1] * pos->y)
			+ nettran[1][2];
	yp = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));

	devup.x = (nettran[0][0] * up->x) + (nettran[0][1] * up->y);
	devup.y = (nettran[1][0] * up->x) + (nettran[1][1] * up->y);
	devpath.x = (nettran[0][0] * path->x) + (nettran[0][1] * path->y);
	devpath.y = (nettran[1][0] * path->x) + (nettran[1][1] * path->y);
		
	if(_gks.asfs.tx_fp == GINDIVIDUAL)
	{
		font= _gks.curtext.fp.font;
		prec= _gks.curtext.fp.prec;
	}

	/*
	 * branch on text precision
	 */
	if( prec == GSTRING )
	{
		t41_txprec(GSTRING,wsptr);
		if(_gks.asfs.tx_color == GINDIVIDUAL)
		{
			t41_txcol(_gks.curtext.color,wsptr);
		}

		/*
		 * get height, round to nearest in pixels
		 */
		height = sqrt((devup.x * devup.x) + (devup.y * devup.y));
		iheight = (int)( height/9.0 + 0.5) * 9;
		if(iheight < 9) iheight = 9;
		htscl = iheight/9;
		cw = htscl * CHARWIDTH;
		ch = htscl * CHARHEIGHT;
		bw = htscl * BOXWIDTH;
		bh = htscl * BOXHEIGHT;
		t41_txsz(0,iheight,0,wsptr);

		/*
		 * count characters to simulate text alignment
		 */
		nchar = 0;
		switch(align->hor)
		{
		case GTH_CENTER:
			nchar = strlen(string);
			xp -= ((nchar-1) * bw  + cw)>>1;
			break;
		case GTH_RIGHT:
			nchar = strlen(string);
			xp -= ((nchar-1) * bw  + cw);
			break;
		default:
			break;
		}

		switch(align->ver)
		{
		case GTV_TOP:
			yp -= 1;
		case GTV_CAP:
			yp -= ch;
			break;
		case GTV_HALF:
			yp -= ch >> 1;
			break;
		case GTV_BOTTOM:
			yp += 2;
			break;
		default:
			break;
		}

		if( ( yp > iymax - ch) || ( yp < iymin))
				return(0);

		sptr = string;
		nchar = 0;
		while ( xp < ixmin)
		{
			xp += bw;
			sptr++;
			if(!(*sptr)) return(0);
		}
		x = xp + cw;
		sptr2 = sptr;
		while( *sptr2 && ( x <= ixmax))
		{
			nchar++;
			sptr2++;
			x += bw;
		}
		if(nchar == 0) return(0);
		xp -= ((bw - cw)>>1);
		if(xp < 0) xp=0;

		t41_mode(VECTOR,wsptr);
		t41_xypack(xp,yp,wsptr);
		t41_mode(ALPHA,wsptr);
		putc(ESC,wsptr->outfile);
		putc('L',wsptr->outfile);
		putc('T',wsptr->outfile);
		t41_ipack(nchar,wsptr);
		while(nchar--)
		{
			putc(*sptr,wsptr->outfile);
			sptr++;
		}
	}
	else
	{
	}

	fflush(wsptr->outfile);
	wsptr->displaysurfempty = GNOTEMPTY;
	return(0);
}
