#include <stdio.h>
#include "../../../include/gks.h"
#include "../../../include/params.h"
#include "../../../include/driver.h"
#include "../../../include/wsstate.h"
#include "../../../include/gksstate.h"
#include "../../../include/extern.h"
#include "../tek4100.h"

t07_pline(npts,points,lnbundl,wsptr)
register Gwsstatelist *wsptr;
register int npts;
Gwpoint *points;
Glnbundl *lnbundl;
{
	register Gwpoint *p=points;
	register struct tek4100control *tc =
						(struct tek4100control *)wsptr->scratchpad;
	register int x1,y1,x2,y2;
	double tempf;
	int fat,linetype;
	Gnrect cliprect;
	Gsegtran nettran;

	/*
	 * if surface is empty, update trans and cliprect on workstation
	 */
	if(wsptr->displaysurfempty)
	{
		if(wsptr->tranudpending)
			t07_wstran(wsptr);
	}
	if(_gks.clipind)
		cliprect = _gks.normtran[_gks.curnormtran].viewport;
	else
		cliprect = _gks.normtran[0].viewport;

	tc->cliprect.ll.x = (int)((4095. * cliprect.ll.x) + 0.5);
	tc->cliprect.ll.y = (int)((4095. * cliprect.ll.y) + 0.5);
	tc->cliprect.ur.x = (int)((4095. * cliprect.ur.x) + 0.5);
	tc->cliprect.ur.y = (int)((4095. * cliprect.ur.y) + 0.5);

	/*
	 * update attributes
	 */
	if(_gks.asfs.ln_color == INDIVIDUAL)
	{
		t41_lncol(_gks.curline.color, wsptr );
	}

	if(_gks.asfs.ln_width == INDIVIDUAL)
	{
		fat = ((int)(_gks.curline.width+0.5) - 1)>>1;
	}

	if(_gks.asfs.ln_type == INDIVIDUAL)
	{
		linetype = _gks.curline.type;
		if(fat==0)
		{
			switch(linetype)
			{
			case 2:
				t41_lnstyle(4,wsptr);
				break;
			case 3:
				t41_lnstyle(1,wsptr);
				break;
			case 4:
				t41_lnstyle(2,wsptr);
				break;
			case 5:
				t41_lnstyle(5,wsptr);
				break;
			case 6:
				t41_lnstyle(6,wsptr);
				break;
			case 7:
				t41_lnstyle(3,wsptr);
				break;
			default:
				t41_lnstyle(0,wsptr);
				break;
			}
		}
	}

	/*
	 * move to first point
	 */
	tempf = 4095. * ((_segtran.m[0] * p->x) + (_segtran.m[2] * p->y)
					+ _segtran.m[4]);
	x1 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	tempf = 4095. * ((_segtran.m[1] * p->x) + (_segtran.m[3] * p->y)
					+ _segtran.m[5]);
	y1 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	p++;

	while(--npts)
	{
		tempf = 4095. * ((_segtran.m[0] * p->x) + (_segtran.m[2] * p->y)
						+ _segtran.m[4]);
		x2 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
		tempf = 4095. * ((_segtran.m[1] * p->x) + (_segtran.m[3] * p->y)
						+ _segtran.m[5]);
		y2 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
		if((x1 != x2) || (y1 != y2))
		{
			t41_vector(x1,y1,x2,y2,fat,0,wsptr);
			x1 = x2; y1 = y2;
		}
		p++;
	}

	/*
	 * reset solid line
	 */
	if( (linetype > 1) && (fat == 0))
		t41_lnstyle(0,wsptr);
	fflush(wsptr->outfile);
	wsptr->displaysurfempty = NOTEMPTY;
}
