#include <stdio.h>
#include <sgtty.h>
#include "../../../include/gks.h"
#include "../../../include/params.h"
#include "../../../include/driver.h"
#include "../../../include/wsstate.h"
#include "../../../include/wstable.h"
#include "../../../include/metafile.h"
#include "../tek4100.h"
char *malloc();

t05_open(wsptr)
register Gwsstatelist *wsptr;
{
	struct sgttyb ttystat;
	int fd;

	wsptr->scratchpad = malloc( sizeof(struct tek4100control));

	fd = fileno(wsptr->infile);
	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags &= (~ECHO);
	ioctl(fd,TIOCSETP,&ttystat);

	/*
	 * Set the graphics window.
	 */

	t41_mode(ALPHA,wsptr);
	putc(ESC,wsptr->outfile);
	putc('R',wsptr->outfile);
	putc('W',wsptr->outfile);
	t41_xypack( 0, 0, wsptr );
	t41_xypack( (int)(wsptr->curviewport.ur.x), 
				(int)(wsptr->curviewport.ur.y), wsptr );

	/*
	 * Set line style to default line.
	 * Set color to default color (usually white, but controlled 
	 *  by color table).
	 */
	t41_lnstyle(0,wsptr);
	t41_lncol(1,wsptr);
	t41_txcol(1,wsptr);
		
	t05_wscntrl(CLEAR,wsptr);
	return;
}
