#include <stdio.h>
#include <sgtty.h>
#include "../../../include/gks.h"
#include "../../../include/params.h"
#include "../../../include/driver.h"
#include "../../../include/wsstate.h"
#include "../../../include/wstable.h"
#include "../../../include/metafile.h"
#include "../tek4100.h"
char *malloc();

t07_loc(wsptr,locdev,position)
register Gwsstatelist *wsptr;
int locdev;
Gnpoint *position;
{
	register struct tek4100control *tc =
			(struct tek4100control *)(wsptr->scratchpad);
	int xp,yp,fd;
	char string[10];
	struct sgttyb ttystat;

	/*
	 * set initial cursor position
	 */
	if( (position->x < wsptr->curwindow.ll.x)||
		(position->x > wsptr->curwindow.ur.x))
			position->x = (wsptr->curwindow.ur.x + wsptr->curwindow.ll.x)/2.;
	if( (position->y < wsptr->curwindow.ll.y)||
		(position->y > wsptr->curwindow.ur.y))
			position->y = (wsptr->curwindow.ur.y + wsptr->curwindow.ll.y)/2.;
	xp = (int)(4095. * position->x + 0.5);
	yp = (int)(4095. * position->y + 0.5);
	t41_mode(ALPHA,wsptr);
	putc(ESC,wsptr->outfile);
	putc('S',wsptr->outfile);
	putc('X',wsptr->outfile);
	putc('0',wsptr->outfile);
	t41_xypack( xp, yp, wsptr );

	fd = fileno(wsptr->infile);
	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags |= (ECHO|CBREAK);
	ioctl(fd,TIOCSETP,&ttystat);
	ioctl(fd,TIOCFLUSH,&ttystat);

	putc(ESC,wsptr->outfile);
	putc('I',wsptr->outfile);
	putc('E',wsptr->outfile);
	putc('0',wsptr->outfile);
	putc('1',wsptr->outfile);
	fflush(wsptr->outfile);

	fread(string,1,7,wsptr->infile);

	tc->mode=ALPHA;
	tc->lost=1;

	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags &= (~ECHO);
	ttystat.sg_flags &= (~CBREAK);
	ioctl(fd,TIOCSETP,&ttystat);

	if(string[0] == '\033')
		return(NONE);

	xp = (((string[4] & 037) << 7) | ((string[5] & 037) << 2) | 
			(string[2] & 03));
	yp = (((string[1] & 037) << 7) | ((string[3] & 037) << 2) |
			((string[2] >> 2) & 03));
	position->x = (double)(xp)/4095.;
	position->y = (double)(yp)/4095.;

	if( (position->x < wsptr->curwindow.ll.x)||
		(position->x > wsptr->curwindow.ur.x)||
		(position->y < wsptr->curwindow.ll.y)||
		(position->y > wsptr->curwindow.ur.y))
	{
		position->x = 0.;
		position->y = 0.;
		return(NONE);
	}
	return(OK);
}
