#include <stdio.h>

#ifndef DOS
#include <sgtty.h>
#endif

#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "metafile.h"
#include "wstable.h"
#include "extern.h"
#include "tek401x.h"
char *malloc();

/*
 * workstation description tables
 */

Gwstable tek401X_wstable={
	GOUTIN,
	{ GDC_OTHER, {1023., 767.}, {1024, 768} }
};


/*
 * dev->open()
 */

tek401X_open(wsptr)
Gwsstatelist *wsptr;
{
#ifndef DOS
	struct sgttyb ttystat;
#endif
	register int fd;

	wsptr->scratchpad = malloc( sizeof(struct tek401Xcontrol));

#ifndef DOS
	fd = fileno(wsptr->infile);
	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags &= (~ECHO);
	ioctl(fd,TIOCSETP,&ttystat);
#endif

	/*
	 * handle initialization of emulators
	 */
	switch(wsptr->type)
	{
	case TEK4014:
	case RETROGRAPHICS:
		putc(GS,wsptr->outfile);
		putc(ESC,wsptr->outfile);
		putc('\140',wsptr->outfile);
		break;
	case GRAPHON:
		putc(ESC,wsptr->outfile);
		putc('1',wsptr->outfile);
		break;
	case DSCAN:
		putc(ESC,wsptr->outfile);
		putc('*',wsptr->outfile);
		break;
	default:
		break;
	}
		
	tek401X_wscontrol(CLEAR,wsptr);
	return;
}

/*
 * dev->close()
 */

tek401X_close(wsptr)
register Gwsstatelist *wsptr;
{
	register struct tek401Xcontrol *tc =
				(struct tek401Xcontrol *)(wsptr->scratchpad);
#ifndef DOS
	struct sgttyb ttystat;
#endif
	register int i,fd;

	tek401X_mode(VECTOR,wsptr);
	tek401X_xypack(0,773,wsptr);
	tek401X_mode(ALPHA,wsptr);

	switch(wsptr->type)
	{
	case TEK4010:
	case TEK4014:
		for( i=tc->messagecount; i > 0; i--)
			putc('\n',wsptr->outfile);
		break;
	case RETROGRAPHICS:
		putc(ESC,wsptr->outfile);
		putc('"',wsptr->outfile);
		putc('0',wsptr->outfile);
		putc('g',wsptr->outfile);
		break;
	case GRAPHON:
		putc(ESC,wsptr->outfile);
		putc('2',wsptr->outfile);
		break;
	case DSCAN:
		putc(ESC,wsptr->outfile);
		putc('$',wsptr->outfile);
		break;
	default:
		break;
	}
	fflush(wsptr->outfile);

#ifndef DOS
	fd = fileno(wsptr->outfile);
	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags &= (~CBREAK);
	ttystat.sg_flags |= (ECHO);
	ioctl(fd,TIOCSETP,&ttystat);
#endif
}


tek401X_pline(npts,points,lncontrol,wsptr)
register int npts;
Gpoint *points;
Glncontrol *lncontrol;
register Gwsstatelist *wsptr;
{
	int fat;
	Glnbundl lnattr;
	double nettran[2][3];
	Glimit netcliprect;

	/*
	 * update wstran, compound nettran, and find net clip rectangle
	 */
	gen_udwstran(wsptr,lncontrol->lc_segtran,lncontrol->lc_cliprect,
					nettran,&netcliprect);

	/*
	 * update attributes
	 */
	gen_wslnattr(wsptr,lncontrol,&lnattr);

	tek401X_color(lnattr.color,wsptr);
	fat = ((int)(lnattr.width+0.5) - 1)>>1;
	if((fat==0) && (lnattr.type > 1))
	{
		switch(wsptr->type)
		{
		case TEK4014:
		case DSCAN:
		case GRAPHON:
			putc(ESC,wsptr->outfile);
			switch(lnattr.type)
			{
			case 2:
				putc('c',wsptr->outfile);
				break;
			case 3:
				putc('a',wsptr->outfile);
				break;
			case 4:
				putc('b',wsptr->outfile);
				break;
			case 5:
				putc('d',wsptr->outfile);
				break;
			case 6:
			case 7:
			default:
				putc('e',wsptr->outfile);
				break;
			}
			break;
		case RETROGRAPHICS:
			putc(ESC,wsptr->outfile);
			switch(lnattr.type)
			{
			case 2:
				putc('b',wsptr->outfile);
				break;
			case 3:
				putc('a',wsptr->outfile);
				break;
			case 4:
				putc('c',wsptr->outfile);
				break;
			case 5:
				putc('d',wsptr->outfile);
				break;
			case 6:
				putc('f',wsptr->outfile);
				break;
			case 7:
			default:
				putc('e',wsptr->outfile);
				break;
			}
			break;
		}
	}

	/*
	 * call generic polyline routine
	 */
	gen_pline(npts,points,nettran,&netcliprect,fat,0,wsptr);

	/*
	 * reset solid line
	 */
	if( (lnattr.type > 1) && (fat == 0))
	{
		switch(wsptr->type)
		{
		case TEK4014:
		case DSCAN:
		case RETROGRAPHICS:
			putc(ESC,wsptr->outfile);
			putc('\140',wsptr->outfile);
			break;
		default:
			break;
		}
	}
	fflush(wsptr->outfile);
	wsptr->displaysurfempty = GNOTEMPTY;
}

#define NOMSIZE	7

tek401X_pmark(npts,points,mkcontrol,wsptr)
register int npts;
Gpoint *points;
Gmkcontrol *mkcontrol;
register Gwsstatelist *wsptr;
{
	double nettran[2][3];
	Glimit netcliprect;
	Gmkbundl mkattr;
	int mksize;

	gen_udwstran(wsptr,mkcontrol->mc_segtran,mkcontrol->mc_cliprect,
					nettran,&netcliprect);

	/*
	 * update attributes
	 */
	gen_wsmkattr(wsptr,mkcontrol,&mkattr);
	mksize = (int)(mkattr.size * NOMSIZE);

	/*
	 * call generic polymarker routine
	 */
	gen_pmark(npts,points,nettran,&netcliprect,mkattr.type,mksize,wsptr);

	fflush(wsptr->outfile);
	wsptr->displaysurfempty = GNOTEMPTY;
}

/*
 * dev->text()
 */
tek401X_text(pos,string,txcontrol,wsptr)
Gpoint *pos;
char string[];
Gtxcontrol *txcontrol;
register Gwsstatelist *wsptr;
{
	register char *sptr;
	int nchar;
	int xp,yp;
	double tempf;
	Gpoint devup,devpath;
	Gtxbundl txattr;
	Glimit netcliprect;
	double nettran[2][3];
	int ixmin,ixmax,iymin,iymax;

	gen_udwstran(wsptr,txcontrol->tc_segtran,txcontrol->tc_cliprect,
					nettran,&netcliprect);

	gen_wstxattr(wsptr,txcontrol,&txattr);

	/*
	 * transform position to integer coordinates.
	 */
	tempf = (nettran[0][0] * pos->x) + (nettran[0][1] * pos->y)
			+ nettran[0][2];
	xp = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	tempf = (nettran[1][0] * pos->x) + (nettran[1][1] * pos->y)
			+ nettran[1][2];
	yp = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));

	/*
	 * branch on text precision
	 */
	if( txattr.fp.prec == GSTRING )
	{
		/*
		 * count characters to simulate text alignment
		 */
		nchar = 0;
		switch(txcontrol->tc_align.hor)
		{
		case GTH_CENTER:
			nchar = strlen(string);
			xp -= ((nchar-1) * BOXW + CHARW)>>1;
			break;
		case GTH_RIGHT:
			nchar = strlen(string);
			xp -= (nchar-1) * BOXW + CHARW;
			break;
		default:
			break;
		}

		switch(txcontrol->tc_align.ver)
		{
		case GTV_TOP:
			yp -= 1;
		case GTV_CAP:
			yp -= CHARH;
			break;
		case GTV_HALF:
			yp -= CHARH >> 1;
			break;
		case GTV_BOTTOM:
			yp += 2;
			break;
		default:
			break;
		}

		/*
		 * convert cliprect to integers
		 */
		ixmin = (int)(netcliprect.xmin + 0.5);
		ixmax = (int)(netcliprect.xmax + 0.5);
		iymin = (int)(netcliprect.ymin + 0.5);
		iymax = (int)(netcliprect.ymax + 0.5);

		if( ( yp > iymax-CHARH) || ( yp < iymin))
				return(0);

		sptr = string;

		while ( (xp < ixmin) && *sptr)
		{
			xp += CHARW;
			sptr++;
		}

		tek401X_mode(VECTOR,wsptr);
		tek401X_xypack(xp,yp,wsptr);
		tek401X_mode(ALPHA,wsptr);
		while( *sptr && ( xp < (ixmax-CHARW)))
		{
			putc(*sptr,wsptr->outfile);
			xp += CHARW;
			sptr++;
		}
	}
	else
	{
	}

	fflush(wsptr->outfile);
	wsptr->displaysurfempty = GNOTEMPTY;
	return(0);
}

/*
 * dev->wscontrol
 */

tek401X_wscontrol(command,wsptr,arg)
int command;
Gwsstatelist *wsptr;
char *arg;
{
	register struct tek401Xcontrol *tc =
							(struct tek401Xcontrol *)(wsptr->scratchpad);

	switch(command)
	{
	case CLEAR:
		tek401X_mode(ALPHA,wsptr);
		putc(ESC, wsptr->outfile);
		putc(FF, wsptr->outfile);
		tc->messagecount = 0;
		tc->lastx = -1;
		tc->lasty = -1;
		fflush(wsptr->outfile);
		wsptr->displaysurfempty = GEMPTY;
		break;
	case UPDATE:
		fflush(wsptr->outfile);
		break;
	case REDRAW_ALL_SEGMENTS_ON:
	case SET_DEFFERAL_STATE_OF:
	case SEND_MESSAGE_TO:
	case SEND_ESCAPE_TO:
		break;
	}
	return;
}

/*
 * dev->wsattr()
 */

tek401X_wsattrib(command,wsptr,arg)
int command;
Gwsstatelist *wsptr;
char *arg;
{
	register struct tek401Xcontrol *tc =
						(struct tek401Xcontrol *)(wsptr->scratchpad);

	switch(command)
	{
	case WINDOW:
		break;
	case VIEWPORT:
		break;
	}
	return;
}

tek401X_loc(wsptr,locdev,response)
Gwsstatelist *wsptr;
int locdev;
Gqloc *response;
{
	register struct tek401Xcontrol *tc =
						(struct tek401Xcontrol *)(wsptr->scratchpad);
	register int fd;
	int xp,yp;
	char string[10];
#ifndef DOS
	struct sgttyb ttystat;

	fd = fileno(wsptr->infile);
	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags |= (CBREAK);
	ioctl(fd,TIOCSETP,&ttystat);
	ioctl(fd,TIOCFLUSH,&ttystat);
#endif

	putc(GS,wsptr->outfile);
	putc(ESC,wsptr->outfile);
	putc(SUB,wsptr->outfile);
	fflush(wsptr->outfile);
	fread(string,1,6,wsptr->infile);
	tc->mode = ALPHA;
	tc->lost = 1;

#ifndef DOS
	ioctl(fd,TIOCGETP,&ttystat);
	ttystat.sg_flags &= (~CBREAK);
	ioctl(fd,TIOCSETP,&ttystat);
#endif

	/*
	 * operator escape
	 */
	if( string[0] == '\033')
	{
		response->status = GNONE;
		return(0);
	}

	xp = (((string[1] & 037) << 5) | (string[2] & 037));
	yp = (((string[3] & 037) << 5) | (string[4] & 037));
	response->loc.position.x = ((double)(xp) - wsptr->xshift)/(wsptr->scale);
	response->loc.position.y = ((double)(yp) - wsptr->yshift)/(wsptr->scale);

	if( (response->loc.position.x < wsptr->curwindow.xmin)||
		(response->loc.position.x > wsptr->curwindow.xmax)||
		(response->loc.position.y < wsptr->curwindow.ymin)||
		(response->loc.position.y > wsptr->curwindow.ymax))
	{
		response->loc.position.x = 0.;
		response->loc.position.y = 0.;
		response->status = GNONE;
		return(0);
	}
	response->status = GOK;
	return(0);
}

#include "code.h"

tek401X_vector(x1,y1,x2,y2,wsptr)
int x1,y1,x2,y2;
Gwsstatelist *wsptr;
{
	register struct tek401Xcontrol *tc =
						(struct tek401Xcontrol *)(wsptr->scratchpad);
	register int dx1,dx2,dy1,dy2;

	if (  (tc->mode != VECTOR) || tc->lost)
	{
		tek401X_mode(VECTOR,wsptr);
		tek401X_xypack(x1,y1,wsptr);
		tek401X_xypack (x2,y2,wsptr);
		tc->lastx = x2; tc->lasty = y2;
		tc->lost = 0;
		return;
	}
	else if ((tc->lastx != x1) || (tc->lasty != y1))
	{
		if((tc->lastx == x2) && (tc->lasty == y2))
		{
			x2 = x1; y2 = y1;
		}
		else
		{
			dx1 = tc->lastx - x1;
			dy1 = tc->lasty - y1;
			if( dx1 < 0) dx1 = -dx1;
			if( dy1 < 0) dy1 = -dy1;
			dx2 = tc->lastx - x2;
			dy2 = tc->lasty - y2;
			if( dx2 < 0) dx2 = -dx2;
			if( dy2 < 0) dy2 = -dy2;
			if((dx2+dy2) < (dx1+dy1))
			{
				dx1 = x1;
				dy1 = y1;
				x1 = x2;
				y1 = y2;
				x2 = dx1;
				y2 = dy1;
			}
			tek401X_mode(VECTOR,wsptr);
			tek401X_xypack(x1,y1,wsptr);
		}
	}
	tek401X_xypack(x2,y2,wsptr);
	tc->lastx = x2; tc->lasty = y2;
}

/*
 * Turn on point (x,y).
 */
tek401X_point(x,y,wsptr)
register int x,y;
Gwsstatelist *wsptr;
{
	register struct tek401Xcontrol *tc =
						(struct tek401Xcontrol *)(wsptr->scratchpad);

	if (  (tc->mode != POINT) || tc->lost)
		tek401X_mode(POINT,wsptr);
	tek401X_xypack(x,y,wsptr);
	tc->lastx = x; tc->lasty = y;
}

/*
 * set and record new Tek mode
 *
 * N.B. we always issue a change to VECTOR when asked since this
 *		is how a move is implemented when we are in VECTOR mode
 *		already
 */
tek401X_mode(mode,wsptr)
register int mode;
register Gwsstatelist *wsptr;
{
	register struct tek401Xcontrol *tc =
						(struct tek401Xcontrol *)(wsptr->scratchpad);

	switch (mode)
	{
	case VECTOR: 
		putc(GS,wsptr->outfile);
		tc->mode = VECTOR;
		tc->lost = 1;
		break;
	case ALPHA: 
		if(tc->mode != ALPHA)
		{
			tc->lost = 1;
			putc(US,wsptr->outfile);
			tc->mode = ALPHA;
		}
		break;
	case POINT: 
		if(tc->mode != POINT)
		{
			tc->lost = 1;
			putc(FS,wsptr->outfile);
			tc->mode = POINT;
		}
		break;
	}
}

/*
 * some 4010 emulators have extended capabilities, including color.
 * this includes those terminals which allow writing in background
 * color to erase.
 */
static char *dscancol = "@ABCDEFG";

tek401X_color(color,wsptr)
register int color;
register Gwsstatelist *wsptr;
{
	register struct tek401Xcontrol *tc =
						(struct tek401Xcontrol *)(wsptr->scratchpad);

	switch(wsptr->type)
	{
	case GRAPHON:
		if(color == 0)
		{
			if(tc->color != 0 )
			{
				putc(ESC,wsptr->outfile);
				putc('\020',wsptr->outfile);
			}
		}
		else
		{
			if(tc->color == 0)
			{
				putc(ESC,wsptr->outfile);
				putc('\01',wsptr->outfile);
			}
		}
		break;
	case DSCAN:
		putc(ESC,wsptr->outfile);
		putc('/',wsptr->outfile);
		putc(dscancol[color],wsptr->outfile);
		break;
	}
	tc->color = color;
}


/*
 * Tek x,y coordinate packing.
 * Previously-encoded positions are saved in
 * ohiy, oloy, etc. in order to abbreviate the number of
 * bytes sent out.
 */
tek401X_xypack (x, y, wsptr)
int x,y;
Gwsstatelist *wsptr;
{
	register struct tek401Xcontrol *tc =
						(struct tek401Xcontrol *)(wsptr->scratchpad);
	register int   hiy, loy, hix, lox;

	/* 
	 * Encode the new position.
	 */
	hiy = 0040 | ((y >> 5) & 037);
	loy = 0140 | (y & 037);
	hix = 0040 | ((x >> 5) & 037);
	lox = 0100 | (x & 037);

	/* 
	 * Only print what's necessary, according to Tek rules.
	 */
	if (hiy != tc->ohiy || tc->lost)
		putc(hiy , wsptr->outfile);
	if (loy != tc->oloy || hix != tc->ohix || tc->lost)
		putc(loy , wsptr->outfile);
	if (hix != tc->ohix || tc->lost)
		putc(hix , wsptr->outfile);
	if (hiy != tc->ohiy || loy != tc->oloy || hix != tc->ohix ||
			lox != tc->olox || tc->lost)
		putc(lox , wsptr->outfile);

	/* 
	 * Remember these for next time.
	 */
	tc->lost=0;
	tc->ohiy = hiy;
	tc->oloy = loy;
	tc->ohix = hix;
	tc->olox = lox;
}

/*
 * Issue a packed integer. From one to three bytes sent.
 */
tek401X_ipack(i,wsptr)
register int i;
Gwsstatelist *wsptr;
{
	register int  ihi, imd, ilo;

	if (i < 0)
	{
		i = -i;
		ilo = 040;
	}
	else
		ilo = 060;

	ihi = 0100 | ((i >> 10) & 037);
	imd = 0100 | ((i >> 4) & 077);
	ilo |= (i & 017);

	if (ihi != 0100)
		putc(ihi , wsptr->outfile);
	if (imd != 0100)
		putc(imd , wsptr->outfile);
	putc(ilo , wsptr->outfile);
}
