#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"
#include "code.h"


gen_wslnattr(wsptr,lc,lnattr)
Gwsstatelist *wsptr;
register Glncontrol *lc;
register Glnbundl *lnattr;
{
	*lnattr = lc->lc_individual;
}

gen_wsmkattr(wsptr,mc,mkattr)
Gwsstatelist *wsptr;
register Gmkcontrol *mc;
register Gmkbundl *mkattr;
{
	*mkattr = mc->mc_individual;
}

gen_wstxattr(wsptr,tc,txattr)
Gwsstatelist *wsptr;
register Gtxcontrol *tc;
register Gtxbundl *txattr;
{
	*txattr = tc->tc_individual;
}

/*
 *   Cohen-Sutherland Clipping routine
 */
gen_clip(x1,y1,x2,y2,rect)
int *x1,*y1,*x2,*y2;
Gilimit *rect;
{
	int c1,c2;
	register int temp;
	int swap;

	c1 = code(*x1,*y1,rect);
	c2 = code(*x2,*y2,rect);
	swap=0;
	while(c1|c2)
	{
		if( c1&c2 ) return(1);  /* line completely out of bounds */
		if(!c1)	/* interchange endpoints */
		{
			temp= *x1;
			*x1= *x2;
			*x2=temp;
			temp= *y1;
			*y1= *y2;
			*y2=temp;
			temp=c1;
			c1=c2;
			c2=temp;
			swap= ~swap;
		}
		if(c1<4)	/* move endpoint in x */
		{
			temp=(c1&2?rect->xmax:rect->xmin);
			*y1= gen_solve(temp,*x1,*y1,*x2,*y2);
			*x1=temp;
		}
		else		/* move endpoint in y */
		{
			temp=(c1&8?rect->ymax:rect->ymin);
			*x1= gen_solve(temp,*y1,*x1,*y2,*x2);
			*y1=temp;
		}
		c1=code(*x1,*y1,rect);
	}
	if( swap )	/* put endpoints in order */
	{
		temp= *x1; 
		*x1= *x2; 
		*x2=temp;
		temp= *y1; 
		*y1= *y2; 
		*y2=temp;
	}
	return(0);
}

/*
 * compute intersection - floating point version
 */
gen_solve(pnot,p1,q1,p2,q2)
register int pnot,p1,q1,p2,q2;
{
	double invslope;
	register int qnot;
	register float tempf;
	if(pnot==p1) return(q1);
	if(pnot==p2) return(q2);
	if(q1==q2) return(q1);
	invslope= (q1-q2)/( (double) (p1-p2));
	tempf = (pnot-p1)*invslope + (double) q1;
	qnot = (tempf > 0) ? tempf+0.5 : tempf-0.5;
	return(qnot);
}

extern Gdevsw _gdevsw[];

gen_pline(npts,points,tran,cliprect,fat,style,wsptr)
register int npts;
Gpoint *points;
double tran[2][3];
Glimit *cliprect;
int fat,style;
Gwsstatelist *wsptr;
{
	register Gpoint *p=points;
	register int x1,y1,x2,y2;
	int x3,y3;
	Gilimit rect;
	double tempf;

	/*
	 * integerize clipping rectangle
	 */
	rect.xmin = (int)(cliprect->xmin + 0.5);
	rect.xmax = (int)(cliprect->xmax + 0.5);
	rect.ymin = (int)(cliprect->ymin + 0.5);
	rect.ymax = (int)(cliprect->ymax + 0.5);

	/*
	 * move to first point
	 */
	tempf = (tran[0][0] * p->x) + (tran[0][1] * p->y) + tran[0][2];
	x1 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	tempf = (tran[1][0] * p->x) + (tran[1][1] * p->y) + tran[1][2];
	y1 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	p++;

	tempf = (tran[0][0] * p->x) + (tran[0][1] * p->y) + tran[0][2];
	x2 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	tempf = (tran[1][0] * p->x) + (tran[1][1] * p->y) + tran[1][2];
	y2 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
	npts--;

	while(--npts)
	{ 
		p++;
		tempf = (tran[0][0] * p->x) + (tran[0][1] * p->y) + tran[0][2];
		x3 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));
		tempf = (tran[1][0] * p->x) + (tran[1][1] * p->y) + tran[1][2];
		y3 = ( tempf < 0.) ? (int)((tempf-0.5)) : ((int)(tempf+0.5));

		if ((x3 == x2) && (y3 == y2))
			continue;
		/*
		 * Is it colinear and horizontal or vertical?
		 */
		if(((y3 == y2) && (y2 == y1) && ((x3 > x2) == (x2 > x1))) ||
		   ((x3 == x2) && (x2 == x1) && ((y3 > y2) == (y2 > y1))) )
		{
			x2 = x3;
			y2 = y3;
			continue;
		}
		gen_vector(x1,y1,x2,y2,fat,0,&rect,wsptr);
		x1 = x2; y1 = y2;
		x2 = x3; y2 = y3;
	}
	gen_vector(x1,y1,x2,y2,fat,0,&rect,wsptr);
}

/*
 * generic vector routine for devices that don't support 
 * both line style and fatness, this routine calls the
 * devsw.vector
 */
gen_vector(x1,y1,x2,y2,fat,style,rect,wsptr)
int x1,y1,x2,y2;
int fat,style;
Gilimit *rect;
Gwsstatelist *wsptr;
{
	register int i,fplus,fminus;
	int xp1,yp1,xp2,yp2;
	Gdevsw *dev;

	xp1 = x1; yp1 = y1; xp2 = x2; yp2 = y2;
	if(gen_clip(&xp1,&yp1,&xp2,&yp2,rect))
		return;

	/*
	 * Recursively calls itself to generate line styles
	 */
	if(style > 1)
	{
		gen_vector(x1,y1,x2,y2,fat,0,rect,wsptr);
		return;
	}
	if(fat>0)		
	{
		fminus = (fat/2); fplus = (fat+1)/2;
		if( x1 <= x2 )
		{
			if(y2 > y1)
			{
				if(x1 == x2)
				{
					for(i = -fminus; i <= fplus; i++)
					{
						xp1 = x1+i; yp1 = y1-fminus;
						xp2 = x2+i; yp2 = y2+fplus;
						gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
					}
				}
				else
				{
					xp1 = x1-fminus; yp1 = y1-fminus;
					xp2 = x2+fplus; yp2 = y2+fplus;
					gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
					for(i = 1; i <(fminus+fplus+1) ; i++)
					{
						xp1 = x1-fminus+i; yp1 = y1-fminus;
						xp2 = x2+fplus; yp2 = y2+fplus-i;
						gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
						xp1 = x1-fminus; yp1 = y1-fminus+i;
						xp2 = x2+fplus-i; yp2 = y2+fplus;
						gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
					}
				}
			}
			else if(y2 == y1)
			{
				for(i = -fminus; i <= fplus; i++)
				{
					xp1 = x1-fminus; yp1 = y1+i;
					xp2 = x2+fplus; yp2 = y2+i;
					gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
				}
			}
			else
			{
				if(x1 == x2)
				{
					for(i = -fminus; i <= fplus; i++)
					{
						xp1 = x1+i; yp1 = y1+fplus;
						xp2 = x2+i; yp2 = y2-fminus;
						gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
					}
				}
				else
				{
					xp1 = x1-fminus; yp1 = y1+fplus;
					xp2 = x2+fplus; yp2 = y2-fminus;
					gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
					for(i = 1; i <(fminus+fplus+1) ; i++)
					{
						xp1 = x1-fminus+i; yp1 = y1+fplus;
						xp2 = x2+fplus; yp2 = y2-fminus+i;
						gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
						xp1 = x1-fminus; yp1 = y1+fplus-i;
						xp2 = x2+fplus-i; yp2 = y2-fminus;
						gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
					}
				}
			}
		}
		else
		{
			if(y2 > y1)
			{
				xp1 = x1+fplus; yp1 = y1-fminus;
				xp2 = x2-fminus; yp2 = y2+fplus;
				gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
				for(i = 1; i <(fminus+fplus+1) ; i++)
				{
					xp1 = x1+fplus; yp1 = y1-fminus+i;
					xp2 = x2-fminus+i; yp2 = y2+fplus;
					gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
					xp1 = x1+fplus-i; yp1 = y1-fminus;
					xp2 = x2-fminus; yp2 = y2+fplus-i;
					gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
				}
			}
			else if(y2 == y1)
			{
				for(i = -fminus; i <= fplus; i++)
				{
					xp1 = x1+fplus; yp1 = y1+i;
					xp2 = x2-fminus; yp2 = y2+i;
					gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
				}
			}
			else
			{
				xp1 = x1+fplus; yp1 = y1+fplus;
				xp2 = x2-fminus; yp2 = y2-fminus;
				gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
				for(i = 1; i <(fminus+fplus+1) ; i++)
				{
					xp1 = x1+fplus; yp1 = y1+fplus-i;
					xp2 = x2-fminus+i; yp2 = y2-fminus;
					gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
					xp1 = x1+fplus-i; yp1 = y1+fplus;
					xp2 = x2-fminus; yp2 = y2-fminus+i;
					gen_vector(xp1,yp1,xp2,yp2,0,0,rect,wsptr);
				}
			}
		}
		return;
	}
	dev = _gdevsw + gmajordev(wsptr->type);
	(*(dev->vector))(xp1,yp1,xp2,yp2,wsptr);
}

/*
 * generic marker routine
 */
static int radius,xd,yd;
static Gilimit rect;
int gen_mark2();
int gen_mark3();
int gen_mark5();

gen_pmark(npts,points,tran,cliprect,type,size,wsptr)
register int npts;
Gpoint *points;
double tran[2][3];
Glimit *cliprect;
int type,size;
Gwsstatelist *wsptr;
{
	register Gpoint *p=points;
	register int x,y,d;
	double xp,yp;
	Gdevsw *dev;
	int (*marker)();

	/*
	 * integerize clipping rectangle
	 */
	rect.xmin = (int)(cliprect->xmin + 0.5);
	rect.xmax = (int)(cliprect->xmax + 0.5);
	rect.ymin = (int)(cliprect->ymin + 0.5);
	rect.ymax = (int)(cliprect->ymax + 0.5);

	radius = size >>1;
	if(radius < 1) type = 1;
	if(type > 2 )
	{
		yd=0;
		xd=radius;
		d = 3 - 2 * radius;
		while( yd < xd)
		{
			if(d < 0) d = d + 4 * yd + 6;
			else
			{
				d = d + 4 * (yd-xd) + 10;
				xd--;
			}
			yd++;
		}
	}

	switch(type)
	{
	case 1:
		dev = _gdevsw + gmajordev(wsptr->type);
		marker = dev->point;
		break;
	case 2:
		marker = gen_mark2;
		break;
	case 5:
		marker = gen_mark5;
		break;
	case 3:
	default:
		marker = gen_mark3;
		break;
	}

	if(marker)
	{
		while(npts--)
		{
			xp = (tran[0][0] * p->x) + (tran[0][1] * p->y) + tran[0][2];
			yp = (tran[1][0] * p->x) + (tran[1][1] * p->y) + tran[1][2];
			if( (xp >= cliprect->xmin) && (xp <= cliprect->xmax) &&
				(yp >= cliprect->ymin) && (yp <= cliprect->ymax))
			{
				x = ( xp < 0.) ? (int)((xp-0.5)) : ((int)(xp+0.5));
				y = ( yp < 0.) ? (int)((yp-0.5)) : ((int)(yp+0.5));
				(*marker)(x,y,wsptr);
			}
			p++;
		}
	}
}

gen_mark2(x,y,wsptr)
int x,y;
Gwsstatelist *wsptr;
{
	register int x1,x2,y1,y2;

	x1 = x - radius; x2 = x + radius;
	y1 = y; y2 = y;
	gen_vector(x1,y1,x2,y2,0,0,&rect,wsptr);
	y1 = y - radius; y2 = y + radius;
	x1 = x; x2 = x;
	gen_vector(x1,y1,x2,y2,0,0,&rect,wsptr);
}

gen_mark3(x,y,wsptr)
int x,y;
Gwsstatelist *wsptr;
{
	register int x1,x2,y1,y2,temp;

	x1 = x - xd;
	y1 = y - yd;
	x2 = x + xd;
	y2 = y + yd;
	gen_vector(x1,y1,x2,y2,0,0,&rect,wsptr);
	temp = x1;
	x1 = x2;
	x2 = temp;
	gen_vector(x1,y1,x2,y2,0,0,&rect,wsptr);
	x1 = x - radius; x2 = x + radius;
	y1 = y; y2 = y;
	gen_vector(x1,y1,x2,y2,0,0,&rect,wsptr);
	y1 = y - radius; y2 = y + radius;
	x1 = x; x2 = x;
	gen_vector(x1,y1,x2,y2,0,0,&rect,wsptr);
}

gen_mark5(x,y,wsptr)
int x,y;
Gwsstatelist *wsptr;
{
	register int x1,x2,y1,y2,temp;

	x1 = x - xd;
	y1 = y - yd;
	x2 = x + xd;
	y2 = y + yd;
	gen_vector(x1,y1,x2,y2,0,0,&rect,wsptr);
	temp = x1;
	x1 = x2;
	x2 = temp;
	gen_vector(x1,y1,x2,y2,0,0,&rect,wsptr);
}

gen_udwstran(wsptr,segtran,cliprect,nettran,netcliprect)
register Gwsstatelist *wsptr;
float segtran[2][3];
Glimit *cliprect,*netcliprect;
double nettran[2][3];
{
	double xscale,yscale;
	int updated=0;

	if(wsptr->displaysurfempty && wsptr->tranudpending)
	{
		wsptr->curwindow = wsptr->reqwindow;
		wsptr->curviewport = wsptr->reqviewport;

		xscale = (wsptr->curviewport.xmax - wsptr->curviewport.xmin)/
			 	(wsptr->curwindow.xmax - wsptr->curwindow.xmin); 
		yscale = (wsptr->curviewport.ymax - wsptr->curviewport.ymin)/
		 		(wsptr->curwindow.ymax - wsptr->curwindow.ymin); 

		wsptr->scale = ( xscale < yscale) ? xscale : yscale;

		wsptr->xshift = wsptr->curviewport.xmin -
						(wsptr->scale * wsptr->curwindow.xmin);
		wsptr->yshift = wsptr->curviewport.ymin -
						(wsptr->scale * wsptr->curwindow.ymin);

		wsptr->tranudpending = GNOTPENDING;
		updated++;
	}

	nettran[0][0] = segtran[0][0] * wsptr->scale;
	nettran[1][0] = segtran[1][0] * wsptr->scale;
	nettran[0][1] = segtran[0][1] * wsptr->scale;
	nettran[1][1] = segtran[1][1] * wsptr->scale;
	nettran[0][2] = segtran[0][2] * wsptr->scale + wsptr->xshift;
	nettran[1][2] = segtran[1][2] * wsptr->scale + wsptr->yshift;

	if(cliprect)
	{
		netcliprect->xmin = (cliprect->xmin > wsptr->curwindow.xmin)
                       ? cliprect->xmin : wsptr->curwindow.xmin;
		netcliprect->ymin = (cliprect->ymin > wsptr->curwindow.ymin)
                       ? cliprect->ymin : wsptr->curwindow.ymin;
		netcliprect->xmax = (cliprect->xmax < wsptr->curwindow.xmax)
                       ? cliprect->xmax : wsptr->curwindow.xmax;
		netcliprect->ymax = (cliprect->ymax < wsptr->curwindow.ymax)
                       ? cliprect->ymax : wsptr->curwindow.ymax;
	}
	else
	{
		netcliprect->xmin= wsptr->curwindow.xmin;
		netcliprect->ymin= wsptr->curwindow.ymin;
		netcliprect->xmax= wsptr->curwindow.xmax;
		netcliprect->ymax= wsptr->curwindow.ymax;
	}
	netcliprect->xmin = netcliprect->xmin * wsptr->scale + wsptr->xshift;
	netcliprect->ymin = netcliprect->ymin * wsptr->scale + wsptr->yshift;
	netcliprect->xmax = netcliprect->xmax * wsptr->scale + wsptr->xshift;
	netcliprect->ymax = netcliprect->ymax * wsptr->scale + wsptr->yshift;

	return(updated);
}
