#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "wstable.h"
#include "f77unit.h"
#include "extern.h"

extern int vplot_open(),vplot_wscontrol(),vplot_pline();
extern int vplot_pmark(),vplot_text();
extern int vplot_vector(),vplot_point();

#ifndef DOS
extern int tek401X_open(),tek401X_wscontrol(),tek401X_close();
extern int tek401X_pline(),tek401X_vector();
extern int tek401X_text(),tek401X_loc(),tek401X_pmark(),tek401X_point();

extern int tek410X_open(),tek410X_close(),tek410X_vector(),tek410X_point();

extern int tek4105_wscontrol(),tek4105_pline(),tek4105_pmark(),tek4105_text();
extern int tek4105_loc();

extern int tek4107_text(),tek4107_wscontrol();
extern int tek4107_segcontrol(),tek4107_segattr();
#else
extern int vgc_open(),vgc_close(),vgc_wscontrol();
extern int vgc_pline(),vgc_pmark(),vgc_loc();
#endif

extern int nulldev();

Gdevsw _gdevsw[] = {
	/*
	 * major 0 - vplot
	 */
	{vplot_open, nulldev,
		vplot_pline, vplot_pmark, vplot_text, nulldev, nulldev, nulldev,
		vplot_wscontrol, nulldev,nulldev, nulldev,
		nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,
		vplot_vector, vplot_point},
	/* 
	 * major 1 - metafile
	 */
	{vplot_open, nulldev,
		vplot_pline, vplot_pmark, vplot_text, nulldev, nulldev, nulldev,
		vplot_wscontrol, nulldev,nulldev, nulldev,
		nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,
		vplot_vector, vplot_point},
	/*
	 * major 2 - tek4010-4014
	 */
#ifndef DOS
	{tek401X_open, tek401X_close,
		tek401X_pline, tek401X_pmark, tek401X_text, nulldev, nulldev, nulldev,
		tek401X_wscontrol, nulldev,nulldev, nulldev,
		tek401X_loc, nulldev, nulldev, nulldev, nulldev, nulldev,
		tek401X_vector, tek401X_point},
#else
	{nulldev, nulldev,
		nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,
		nulldev, nulldev,nulldev, nulldev,
		nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,
		nulldev, nulldev},
#endif
	/*
	 * major 3 - tek4105
	 */
#ifndef DOS
	{tek410X_open, tek410X_close,
		tek4105_pline, tek4105_pmark, tek4105_text, nulldev, nulldev, nulldev,
		tek4105_wscontrol, nulldev,nulldev, nulldev,
		tek4105_loc, nulldev, nulldev, nulldev, nulldev, nulldev,
		tek410X_vector, tek410X_point },
#else
	{nulldev, nulldev,
		nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,
		nulldev, nulldev,nulldev, nulldev,
		nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,
		nulldev, nulldev},
#endif
	/*
	 * major 4 - tek4106-9
	 */
#ifndef DOS
	{tek410X_open, tek410X_close,
		tek4105_pline, tek4105_pmark, tek4107_text, nulldev, nulldev, nulldev,
		tek4107_wscontrol, nulldev, tek4107_segcontrol, tek4107_segattr,
		tek4105_loc, nulldev, nulldev, nulldev, nulldev, nulldev,
		tek410X_vector, tek410X_point },
#else
	{nulldev, nulldev,
		nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,
		nulldev, nulldev,nulldev, nulldev,
		nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,
		nulldev, nulldev},
#endif
	/*
	 * major 5 - envisions
	 */
	{nulldev, nulldev,
		nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,
		nulldev, nulldev,nulldev, nulldev,
		nulldev, nulldev, nulldev, nulldev, nulldev, nulldev,
#ifdef DOS
		nulldev, nulldev},
	/*
	 * major 6 - DEC REGIS or VERTICOM on PCs
	 */
	{vgc_open, vgc_close,
		vgc_pline, vgc_pmark, nulldev, nulldev, nulldev, nulldev,
		vgc_wscontrol, nulldev,nulldev, nulldev,
		vgc_loc, nulldev, nulldev, nulldev, nulldev, nulldev,
#endif
		nulldev, nulldev}
};
int _gndevsw = (sizeof(_gdevsw)/sizeof(_gdevsw[0]));

extern Gwstable vplot_wstable;
extern Gwstable tek401X_wstable,tek4105_wstable,tek4107_wstable;

#ifdef DOS
extern Gwstable vgch16_wstable,vgcm16_wstable,vgcm256_wstable,vgch256_wstable;
#endif

/*
 * there are 8 possible minor devices for every major device,
 * we fill in all the slots, later some will change as the tables
 * get specific about number of colors and such... envision entries
 * differ by on screen resolution
 */

Gwstable *_wstable[] = {
/* major device 0 , vplot metafile*/
	&vplot_wstable,&vplot_wstable,&vplot_wstable,&vplot_wstable,
	&vplot_wstable,&vplot_wstable,&vplot_wstable,&vplot_wstable,
/* major device 1 , metafiles*/
	&vplot_wstable,&vplot_wstable,&vplot_wstable,&vplot_wstable,
	&vplot_wstable,&vplot_wstable,&vplot_wstable,&vplot_wstable,
/* major device 2 , tek4010*/
	&tek401X_wstable,&tek401X_wstable,&tek401X_wstable,&tek401X_wstable,
	&tek401X_wstable,&tek401X_wstable,&tek401X_wstable,&tek401X_wstable,
/* major device 3, tek4105 */
	&tek4105_wstable,&tek4105_wstable,&tek4105_wstable,&tek4105_wstable,
	&tek4105_wstable,&tek4105_wstable,&tek4105_wstable,&tek4105_wstable,
/* major device 4, tek410[6-9] */
	&tek4107_wstable,&tek4107_wstable,&tek4107_wstable,&tek4107_wstable,
	&tek4107_wstable,&tek4107_wstable,&tek4107_wstable,&tek4107_wstable,
/* major device 5, envision */
	&tek4107_wstable,&tek4107_wstable,&tek4107_wstable,&tek4107_wstable,
	&tek4107_wstable,&tek4107_wstable,&tek4107_wstable,&tek4107_wstable,
#ifdef DOS
/* major device 6, VERTICOM or REGIS */
	&vgcm16_wstable,&vgcm256_wstable,&vgch16_wstable,&vgch256_wstable,
	&tek4107_wstable,&tek4107_wstable,&tek4107_wstable,&tek4107_wstable,
#endif
};

nulldev()
{
	return(0);
}
