/*
 * GKS FUNCTION NAME:  Update Workstation
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gupdatews(ws,flag)
 *
 *        int ws;
 *        int flag;
 *
 *    FORTRAN SYNTAX:
 *
 *        call guwk(wkid,flag)
 *        integer wkid
 *        integer flag
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "metafile.h"
#include "extern.h"

static char *name="Update Workstation";

#ifdef FORTRAN

#define GUWK	guwk_
#define WS		*ws
#define FLAG	*flag

#else

#define GUWK	guwk
#define WS		ws
#define FLAG	flag

#endif

GUWK(ws,flag)
int WS;
int FLAG;
{
	register Gwsstatelist *wsptr;
	register Gdevsw *dev;
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_7)
	{
		error=7;
		goto gkserror;
	}
	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error=20;
		goto gkserror;
	}
#endif

	wsptr = _gks.workstation[WS];
	if( !wsptr) 
	{
		error=25;
		goto gkserror;
	}

	dev = _gdevsw + gmajordev(wsptr->type);
	if(dev->wscontrol) (*(dev->wscontrol))(UPDATE,wsptr);
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
