/*
 * GKS FUNCTION NAME:  Open Workstation
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gopenws(wsid,connid,type)
 *        int wsid;
 *        FILE *connid;
 *        char *type;
 *
 *     FORTRAN SYNTAX:
 *
 *        call gopwk(wkid,connid,wktype)
 *        integer wkid
 *        integer connid
 *        char *wktype
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "wstable.h"
#include "f77unit.h"
#include "extern.h"
char *calloc();
#ifndef DOS
char *ttyname();
#endif
extern Gwstable *_wstable[];

static char *name="Open Workstation";

#ifdef FORTRAN

#define	WS			*ws

gopwk(ws,lunum,typename)
int WS;
int *lunum;

#else

#define	WS			ws

gopwk(ws,file,typename)
int WS;
FILE *file;

#endif
char *typename;
{
	register Gwsstatelist *wsptr;
	register int dev,wstype;
	Gwstable *wsd;
#ifdef FORTRAN
	unit *uptr;
	FILE *file;
#endif
	int error;
	char *terminal;

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		error=8;
		goto gkserror;
	}
	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error=20;
		goto gkserror;
	}
	else if( _gks.workstation[WS])
	{
		error=24;
		goto gkserror;
	}
#endif

	wstype = gwstype(typename);
	dev = gmajordev(wstype);

#ifndef FAST
	if((wstype <= 0) || (dev >= _gndevsw))
	{
		error=22;
		goto gkserror;
	}
#endif

#ifdef FORTRAN
	uptr = units+(*lunum);
	file = uptr->ufd;
#endif
	wsptr = (Gwsstatelist *)calloc(1, sizeof(Gwsstatelist));

	if( !wsptr )
	{
		error=26;
		goto gkserror;
	}

	_gks.workstation[WS] = wsptr;
	wsptr->type = wstype;
	wsd = _wstable[wstype];

	if((wsd->category == GINPUT) || (wsd->category == GMI))
	{
		wsptr->infile = file;
	}
	else
	{
		wsptr->outfile = file;
	}

	if(wsd->category == GOUTIN)
	{
#ifdef DOS
		wsptr->infile = fopen("/dev/con","r");
		if(wsptr->infile)
			setbuf(wsptr->infile,NULL);
#else
		if( terminal = ttyname(fileno(file)) )
		{
			wsptr->infile = fopen(terminal,"r");
			if(wsptr->infile)
				setbuf(wsptr->infile,NULL);
		}
#endif
	}

	wsptr->curwindow.xmin = 0.;
	wsptr->curwindow.ymin = 0.;
	wsptr->curwindow.xmax = 1.0;
	wsptr->curwindow.ymax = 1.0;
	wsptr->reqwindow = wsptr->curwindow;
	wsptr->curviewport.xmin = 0.;
	wsptr->curviewport.ymin = 0.;
	wsptr->curviewport.xmax = wsd->dspsize.device.x;
	wsptr->curviewport.ymax = wsd->dspsize.device.y;
	wsptr->reqviewport = wsptr->curviewport;
	if(_gdevsw[dev].open) (*(_gdevsw[dev].open))(wsptr);
	wsptr->isactive = GINACTIVE;
	wsptr->tranudpending = GPENDING;
	wsptr->displaysurfempty = GEMPTY;
	_gks.state = GWSOP;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}

gwstype(wstype)
char *wstype;
{
	if( !strcmp(wstype,"tek4010") )
		return(TEK4010);
#ifdef DOS
	else if( !strcmp(wstype,"verticom_m16") )
		return(VGCM16);
	else if( !strcmp(wstype,"verticom_m256") )
		return(VGCM256);
	else if( !strcmp(wstype,"verticom_h16") )
		return(VGCH16);
	else if( !strcmp(wstype,"verticom_h256") )
		return(VGCH256);
#endif
	else if( !strcmp(wstype,"tek4012") )
		return(TEK4010);
	else if( !strcmp(wstype,"tek4013") )
		return(TEK4010);
	else if( !strcmp(wstype,"tek4014") )
		return(TEK4014);
	else if( !strcmp(wstype,"graphon") )
		return(GRAPHON);
	else if( !strcmp(wstype,"retrographics") )
		return(RETROGRAPHICS);
	else if( !strcmp(wstype,"dscan") )
		return(DSCAN);
	else if( !strcmp(wstype,"tek4105") )
		return(TEK4105);
	else if( !strcmp(wstype,"tek4106") )
		return(TEK4106);
	else if( !strcmp(wstype,"tek4107") )
		return(TEK4107);
	else if( !strcmp(wstype,"tek4109") )
		return(TEK4109);
	else if( !strcmp(wstype,"vplot") )
		return(VPLOT);
	else
		return(0);
}
