/*
 * GKS FUNCTION NAME:  Open GKS
 *
 *    C SYNTAX:
 *
 *        #include <stdio.h>
 *        #include <gks.h>
 *
 *        gopengks(memory,errfile)
 *        long memory;
 *        FILE *errfile;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gopks(memory,lerrun)
 *        integer memory
 *        integer lerrun
 * (lerrun = logical error unit)
 *
 *    "memory" argument is currently a no-op (it does nothing).
 *    "errfile" or "lerrun" refer to an existing file that is already
 * open for writing error messages.  Its address is copied into an
 * appropriate structure for use by other gks routines.
 *
   Revisions:
	2 Jul 1990 - P. Farrell - gemergencyclosegks function must be 
   declared of type "void" on Digital RISC ULTRIX systems (DECsystem,
   DECstation).  I included an ifdef that will do this properly, based on
   automatic compiler flag "MIPSEL" for such machines.  For BSD UNIX,
   stays as type "int".
 */

#include <stdio.h>
#include <signal.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "f77unit.h"
#include "extern.h"

static char *name="Open GKS";

Gksstatelist _gks;

Glnbundl _deflnbundl = { 1, 1.0, 7};
Gmkbundl _defmkbundl = { 3, 1.0, 7};
Gtxbundl _deftxbundl = { {1,0}, 1.0, 1.0, 7};
Gpoint _defcharup = { 0.0, 1.0};
Gtxalign _deftxalign = { GTH_NORMAL, GTV_NORMAL};
Gasfs _defasfs = {0,0,0,0,0,0,0,0,0,0,0,0,0};
struct Gnormtran _defnormtran = {
	{0.,1.,0.,1.},
	{0.,1.,0.,1.},
	0,0,
	1.0,1.0,0.0,0.0
};

float _segtran[2][3] = {
	{1.0, 0.0, 0.0},
	{0.0, 1.0, 0.0}
};

/*
 * signal catching
 */
#ifdef MIPSEL
void	gemergencyclosegks();
#else
int	gemergencyclosegks();
#endif

#ifdef BSD
static int  signum[] =
{
	SIGHUP, SIGINT, SIGQUIT, SIGIOT, SIGEMT, SIGPIPE, SIGTERM, SIGXCPU, 
	SIGFPE, SIGXFSZ
};
#define NOSIG (sizeof (signum)/sizeof (int))	/* number of signals caught */
static struct sigvec errhandler =
{
	gemergencyclosegks, 0, 0
};
static struct sigvec ignored =
{
	SIG_IGN, 0, 0
};
static struct sigvec  oldvec;
#endif

#ifdef FORTRAN

#define GOPKS		gopks_
#define MEMORY		*memory
#define ERRFILE		lunit
#define GFILE		int

#else

#define GOPKS		gopks
#define MEMORY		memory
#define ERRFILE		errfile
#define GFILE		FILE

#endif

GOPKS(memory,ERRFILE)
long MEMORY;
GFILE *ERRFILE;
{
	register int i;
#ifdef FORTRAN
	FILE *errfile;
	unit *uptr;
#endif
	int error;

#ifdef FORTRAN
/*
	units is the fortran logical units table, defined in f77units.h
        Look up the C-type FILE pointer associated with the Fortran 
	logical unit number and store that in variable "errfile".
*/
	uptr = units+(*lunit);
	errfile = uptr->ufd;
/*
	Call a low-level routine from the Fortran compiler I/O library
	to set the error file open for appending.  This routine has a 
	different name/syntax under 4.3BSD versus 4.2BSD, so I provide
	an ifdef here to select the correct one.
*/
#ifdef FOURTHREEBSD
	nowwriting(uptr);
#else
	now_acc( uptr, "a");
#endif

#endif

	_gks.errfile = errfile;

	_gks.curlineindex  = 1;
	_gks.curline = _deflnbundl;
	_gks.curmarkerindex = 1;
	_gks.curmarker = _defmkbundl;
	_gks.curtextindex = 1;
	_gks.curtext = _deftxbundl;
	_gks.charheight = 0.05;
	_gks.charup = _defcharup;
	_gks.textpath = GTP_RIGHT;
	_gks.textalign = _deftxalign;
	_gks.asfs = _defasfs;

	_gks.curnormtran = 0;
	_gks.highnormtran = _gks.normtran;
	for(i=0; i<NNORMTRAN; i++)
	{
		_gks.normtran[i] = _defnormtran;
		if(i)
			_gks.normtran[i].higher = &(_gks.normtran[i-1]);
		if(i <(NNORMTRAN-1))
			_gks.normtran[i].lower = &(_gks.normtran[i+1]);
	}
	_gks.normtran[0].higher = 0;
	_gks.normtran[NNORMTRAN-1].lower = 0;
	_gks.clipind = GCLIP;
	_gks.openseg = 0;

	/*
	 * caught signals call gemergencyclosegks
	 */
#ifdef BSD
	for (i = 0; i < NOSIG; i++)
	{
		if (-1 == sigvec (signum[i], &ignored, &oldvec)) continue;
		if (oldvec.sv_handler == ignored.sv_handler)
			(void) sigvec (signum[i], &oldvec, (struct sigvec *) 0);
		else
			(void) sigvec (signum[i], &errhandler, (struct sigvec  *) 0);
	}
#else
	signal(SIGINT, gemergencyclosegks);
#endif

	_gks.state = GGKOP;
	return(0);
}
