/*
 * GKS FUNCTION NAME:  Deactivate Workstation
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gdeactivatews(ws)
 *
 *        int ws;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gdacwk(wkid)
 *        integer wkid
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "metafile.h"
#include "extern.h"

static char *name="Deactivate Workstation";

#ifdef FORTRAN

#define GDACWK	gdacwk_
#define WS		*ws

#else

#define GDACWK	gdacwk
#define WS		ws

#endif

GDACWK(ws)
int WS;
{
	register Gwsstatelist *wsptr;
	int error;

#ifndef FAST
	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error=20;
		goto gkserror;
	}
#endif

	wsptr = _gks.workstation[WS];

	if( !wsptr) 
	{
		error=25;
		goto gkserror;
	}

#ifndef FAST
	if( !(wsptr->isactive))
	{
		error=30;
		goto gkserror;
	}
#endif

	wsptr->isactive = GINACTIVE;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
