/*
 * GKS FUNCTION NAME:  Close Workstation
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gclosews(ws)
 *
 *        int ws;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gclwk(wkid)
 *        integer wkid
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "metafile.h"
#include "extern.h"

static char *name="Close Workstation";

#ifdef FORTRAN

#define GCLWK	gclwk_
#define WS		*ws

#else

#define GCLWK	gclwk
#define WS		ws

#endif

GCLWK(ws)
int WS;
{
	register Gwsstatelist *wsptr;
	register Gdevsw *dev;
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_7)
	{
		error=7;
		goto gkserror;
	}
	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error=20;
		goto gkserror;
	}
#endif

	wsptr = _gks.workstation[WS];
	if( !wsptr) 
	{
		error=25;
		goto gkserror;
	}

#ifndef FAST
	if( wsptr->isactive)
	{
		error=29;
		goto gkserror;
	}
#endif


	dev = _gdevsw + gmajordev(wsptr->type);
	if(dev->close) (*(dev->close))(wsptr);
	if( wsptr->infile && (wsptr->infile != stdin))
	{
		fclose(wsptr->infile);
	}
	free(wsptr);
	_gks.workstation[WS] = 0;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
