/*
 * GKS FUNCTION NAME:  Clear Workstation
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gclearws(ws,flag)
 *        int ws;
 *        int flag;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gclrwk(wkid,flag)
 *        integer wkid
 *        integer flag
 *
 */

#include <stdio.h>
#include "gks.h"
#include "device.h"
#include "config.h"
#include "wsstate.h"
#include "gksstate.h"
#include "metafile.h"
#include "extern.h"

static char *name="Clear Workstation";

#ifdef FORTRAN

#define GCLRWK	gclrwk_
#define WS		*ws
#define FLAG	*flag

#else

#define GCLRWK	gclrwk
#define WS		ws
#define FLAG	flag

#endif

GCLRWK(ws,flag)
int WS;
int FLAG;
{
	register Gwsstatelist *wsptr;
	register Gdevsw *dev;
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_6)
	{
		error=6;
		goto gkserror;
	}
	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error=20;
		goto gkserror;
	}
#endif

	wsptr = _gks.workstation[WS];
	if( !wsptr) 
	{
		error=25;
		goto gkserror;
	}

	dev = _gdevsw + gmajordev(wsptr->type);
	if(dev->wscontrol) (*(dev->wscontrol))(CLEAR,wsptr);
	wsptr->displaysurfempty = GEMPTY;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
