/*
 * GKS FUNCTION NAME:  Activate Workstation
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gactivatews(ws)
 *        int ws;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gacwk(wkid)
 *        integer wkid
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "metafile.h"
#include "extern.h"

static char *name="Activate Workstation";

#ifdef FORTRAN

#define GACWK	gacwk_
#define WS		*ws

#else

#define GACWK	gacwk
#define WS		ws

#endif

GACWK(ws)
int WS;
{
	register Gwsstatelist *wsptr;
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_6)
	{
		error = 6;
		goto gkserror;
	}
	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error = 20;
		goto gkserror;
	}
#endif

	wsptr = _gks.workstation[WS];

	if( !wsptr) 
	{
		error=25;
		goto gkserror;
	}

#ifndef FAST
	if( wsptr->isactive)
	{
		error=29;
		goto gkserror;
	}
#endif

	wsptr->isactive = GACTIVE;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
