/*
 * GKS FUNCTION NAME:  Set Text Font and Precision
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsettextfontprec(fp)
 *        Gtxfp *fp;
 * 
 *    FORTRAN SYNTAX:
 *
 *        call gstxfp(font,prec)
 *        integer font,prec
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Text Font and Precision";

#ifdef FORTRAN

gstxfp_(font,prec)
int *font, *prec;
{
	Gtxfp f;
	register Gtxfp *fp = &f;
#else

gstxfp(fp)
register Gtxfp *fp;
{
#endif
	int gkserror;

#ifdef FORTRAN
	fp->font = *font;
	fp->prec = *prec;
#endif

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		gkserror=8;
		goto error;
	}
	if( fp->font <= 0)
	{
		gkserror=70;
		goto error;
	}
#endif

	_gks.curtext.fp = *fp;
	return(0);

error:
	gerrorhand(gkserror,name);
	return(gkserror);
}
