/* 
 * GKS FUNCTION NAME:  Set Text Color Index
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsettextcolor(color)
 *        int color;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gstxci(color)
 *        integer color
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Text Color Index";

#ifdef FORTRAN

#define GSTXCI	gstxci_
#define COLOR	*color

#else

#define GSTXCI	gstxci
#define COLOR	color

#endif

GSTXCI(color)
register int COLOR;
{
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		error = 8;
		goto gkserror;
	}
	if(COLOR < 0)
	{
		error=85;
		goto gkserror;
	}
#endif

	_gks.curtext.color = COLOR;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
