/*
 * GKS FUNCTION NAME:  Set Text Alignment
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsettextalign(align)
 *        Gtxalign *align;
 * 
 *    FORTRAN SYNTAX:
 *
 *        call gstxal(halign,valign)
 *        integer halign,valign
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Text Alignment";

#ifdef FORTRAN

gstxal_(halign,valign)
int *halign, *valign;
{
	Gtxalign a;
	register Gtxalign *align = &a;
	align->hor = *halign;
	align->ver = *valign;

#else

gstxal(align)
Gtxalign *align;
{

#endif

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		gerrorhand(8,name);
		return(8);
	}
#endif

	_gks.textalign = *align;
	return(0);
}
