/* 
 * GKS FUNCTION NAME:  Set Polymarker Color Index
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetmarkercolor(color)
 *        int color;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gspmci(color)
 *        integer color
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Polymarker Color Index";

#ifdef FORTRAN

#define GSPMCI	gspmci_
#define COLOR	*color

#else

#define GSPMCI	gspmci
#define COLOR	color

#endif

GSPMCI(color)
register int COLOR;
{
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		error=8;
		goto gkserror;
	}
	if( COLOR < 0)
	{
		error=85;
		goto gkserror;
	}
#endif
	_gks.curmarker.color = COLOR;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
