/* 
 * GKS FUNCTION NAME:  Set Polyline Color Index
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetlinecolor(color)
 *        int color;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gsplci(color)
 *        integer color
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Polyline Color Index";

#ifdef FORTRAN

#define GSPLCI	gsplci_
#define COLOR	*color

#else

#define GSPLCI	gsplci
#define COLOR	color

#endif

GSPLCI(color)
register int COLOR;
{
	int error;

#ifndef FAST
	if( GKS_STATE_ERROR_8)
	{
		error = 8;
		goto gkserror;
	}
	if (COLOR < 0)
	{
		error=85;
		goto gkserror;
	}
#endif

	_gks.curline.color = COLOR;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
