/* 
 * GKS FUNCTION NAME:  Set Marker Size Scale Factor
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetmarkersize(scale)
 *        float scale;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gsmksc(scale)
 *        real scale
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Marker Size Scale Factor";

#ifdef FORTRAN

#define GSMKSC	gsmksc_
#define SCALE	*scale

#else

#define GSMKSC	gsmksc
#define SCALE	scale

#endif

GSMKSC(scale)
float SCALE;
{

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		gerrorhand(8,name);
		return(8);
	}
#endif

	_gks.curmarker.size = SCALE;
	return(0);
}
