/*
 * GKS FUNCTION NAME:  Set Marker Type
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetmarkertype(type)
 *        int type;
 * 
 *
 *    FORTRAN SYNTAX:
 *
 *        call gsmk(type)
 *        integer type
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Marker Type";

#ifdef FORTRAN

#define GSMK	gsmk_
#define TYPE	*type

#else

#define GSMK	gsmk
#define TYPE	type

#endif

GSMK(type)
register int TYPE;
{
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		error=8;
		goto gkserror;
	}
	if(TYPE <= 0)
	{
		error=66;
		goto gkserror;
	}
#endif

	_gks.curmarker.type = TYPE;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
