/* 
 * GKS FUNCTION NAME:  Set Linewidth Scale Factor
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetlinewidth(width)
 *        float width;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gslwsc(width)
 *        real width
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Linewidth Scale Factor";

#ifdef FORTRAN

#define GSLWSC	gslwsc_
#define WIDTH	*width

#else

#define GSLWSC	gslwsc
#define WIDTH	width

#endif

GSLWSC(width)
float WIDTH;
{

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		gerrorhand(8,name);
		return(8);
	}
#endif

	_gks.curline.width = WIDTH;
	return(0);
}
