/* 
 * GKS FUNCTION NAME:  Set Line Type
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetlinetype(type)
 *        int type;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gsln(ltype)
 *        integer ltype
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Line Type";

#ifdef FORTRAN

#define GSLN	gsln_
#define TYPE	*type

#else

#define GSLN	gsln
#define TYPE	type

#endif

GSLN(type)
register int TYPE;
{
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		error = 8;
		goto gkserror;
	}
	if( TYPE <= 0 )
	{
		error=62;
		goto gkserror;
	}
#endif

	_gks.curline.type = TYPE;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
