/*
 * GKS FUNCTION NAME:  Set Character Up Vector
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetcharup(up)
 *        Gpoint *up;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gschup(chux,chuy)
 *        real chux,chuy
 *
 */


#include <stdio.h>
#include <math.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Character Up Vector";

#ifdef FORTRAN

#define X	(*chux)
#define Y	(*chuy)

gschup_(chux,chuy)
float *chux,*chuy;

#else

#define X	(up->x)
#define Y	(up->y)

gschup(up)
Gpoint *up;

#endif
{
	double sqrt(),length;
	int error;

#ifndef FAST
	if( GKS_STATE_ERROR_8 )
	{
		error = 8;
		goto gkserror;
	}
#endif

	length = sqrt((double)((X * X) + (Y * Y)));
	
	if(length == 0.)
	{
		error=74;
		goto gkserror;
	}

	_gks.charup.x = X/length;
	_gks.charup.y = Y/length;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
