/*
 * GKS FUNCTION NAME:  Set Character Height
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetcharheight(height)
 *        float height;
 * 
 *    FORTRAN SYNTAX:
 *
 *	      call gschh(height)
 *	      real height
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Character Height";

#ifdef FORTRAN

#define GSCHH	gschh_
#define HEIGHT	*height

#else

#define GSCHH	gschh
#define HEIGHT	height

#endif

GSCHH(height)
float HEIGHT;
{
	int error;

#ifndef FAST
	if( GKS_STATE_ERROR_8)
	{
		error = 8;
		goto gkserror;
	}
	if( HEIGHT <= 0.)
	{
		error=73;
		goto gkserror;
	}
#endif

	_gks.charheight = HEIGHT;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
