
#include <stdio.h>
#include <strings.h>
#include <ctype.h>
#include "gks.h"
#include "graph.h"
static char *ident = "@(#) %M% %I%";

extern char *malloc(), *calloc();
extern double atof();
extern struct _iobuf *textbuffer;
/* MIXED is taken from fastpar.h, in the vplot filters library;
	it should be put into a globally-accessible header file. */
typedef struct { int *i; float *f; double *g; char *s } MIXED;

struct mesg *storemesg (where, string, msgs)
char  *where, *string;
struct mesg *msgs;
{
	static int nmesg = 0;
	extern char name[];
	struct mesg *new_mesg;
	char tx_align[40], xstr[20], ystr[20], sizestr[20];
	float xx = 0., orient = 0.;
	int count, ii = 0, tx_font;
	static int tx_color = 7;

	/*
	 * allocate a new message structure, and link it into the list
	 */
	if (++nmesg > MAXMESG)
	{
		fprintf (stderr, "%s: storemesg: too many messages.\n", name);
		return (msgs);
	}
	/*
	 * by default, text attributes are the same as for the previous message.
	 */
	new_mesg = (struct mesg *) malloc ((unsigned)sizeof(struct mesg));
	bufpar_scan(textbuffer->_base, textbuffer->_cnt, 0);
	if (new_mesg == (struct mesg *)NULL)
	{
		fprintf (stderr, 
			"%s: storemesg: couldn't allocate space for message %d\n",
			name, nmesg);
		return (msgs);
	}
	msgs->next = new_mesg;
	new_mesg->prev = msgs;

	strncpy (new_mesg->string, string, sizeof(new_mesg->string)-1);
	/*
	 * get the location, size, and orientation of the text
	 */
	/* VARARGS2 */
	count = sscanf(where, "%*c %s %s %s %f", xstr, ystr, sizestr, &orient);
	if (count<2 || count>4)
	{
		fprintf(stderr,"%s: bad mesg spec: %s\n", name, where);
		fprintf (stderr, "count = %d\n", count);
		return (msgs);
	}

	/* parse control info */
	if (str_to_num (xstr, &xx, &ii) == -1)
	{
		fprintf(stderr,"%s: bad mesg spec: %s\n", name, xstr);
		fprintf(stderr,"xstr no good \n");
		return (msgs);
	}
	else
	{
		new_mesg->location.x = xx;	/* abscissa of reference point */
		new_mesg->locunits.x = ii;	/* type of units for abscissa */
	}

	if (str_to_num (ystr, &xx, &ii) == -1)
	{
		fprintf(stderr,"%s: bad mesg spec: %s\n", name, ystr);
		fprintf(stderr,"ystr no good \n");
		return (msgs);
	}
	else
	{
		new_mesg->location.y = xx; /* ordinate of reference point */
		new_mesg->locunits.y = ii; /* type of units for ordinate */
	}

	if (count > 2)
	{
		if ((str_to_num (sizestr, &xx, &ii) == -1) || (xx <= 0))
		{
			fprintf(stderr,"%s: bad mesg spec: %s\n", name, sizestr);
			fprintf(stderr,"sizestr no good \n");
			fflush(stderr);
			return (msgs);
		}
		else
		{
			new_mesg->size = xx;	/* character height */
			new_mesg->sizeunits = ii; /* in what units ? */
		}
	}
	else
		new_mesg->size = msgs->size;

	if (count == 4)
		new_mesg->orient = orient;
	else
		new_mesg->orient = msgs->orient;

	/*
	 * two values must be given for tx_align: horizontal, vertical
	 * they should be in a quoted string, separated by blanks
	 */
	if (count = bufpar_("txjust txalign","s",(MIXED *)tx_align))
	{
		if (count == -1)
		{
			fprintf(stderr,"%s: bad tx_align spec\n", name);
			return (msgs);
		}
		if (count = sscanf(tx_align, "%s %s", xstr, ystr) != 2)
		{
			fprintf(stderr,"%s: bad mesg spec: %s\n", name, tx_align);
			return (msgs);
		}

		to_lower(xstr);
		if (!strcmp(xstr, "normal"))
			new_mesg->tjust.hor = GTH_NORMAL;
		else if (!strcmp(xstr, "left"))
			new_mesg->tjust.hor = GTH_LEFT;
		else if (!strcmp(xstr, "right"))
			new_mesg->tjust.hor = GTH_RIGHT;
		else if (!strcmp(xstr, "center"))
			new_mesg->tjust.hor = GTH_CENTER;
		else
		{
			fprintf(stderr,"%s: bad mesg spec: %s\n", name, xstr);
			return (msgs);
		}

		to_lower(ystr);
		if (!strcmp(ystr, "normal"))
			new_mesg->tjust.ver = GTV_NORMAL;
		else if (!strcmp(ystr, "top"))
			new_mesg->tjust.ver = GTV_TOP;
		else if (!strcmp(ystr, "cap"))
			new_mesg->tjust.ver = GTV_CAP;
		else if (!strcmp(ystr, "half"))
			new_mesg->tjust.ver = GTV_HALF;
		else if (!strcmp(ystr, "base"))
			new_mesg->tjust.ver = GTV_BASE;
		else if (!strcmp(ystr, "bottom"))
			new_mesg->tjust.ver = GTV_BOTTOM;
		else
		{
			fprintf(stderr,"%s: bad mesg spec: %s\n", name, ystr);
			return (msgs);
		}
	}
	else
	{
		new_mesg->tjust.hor = msgs->tjust.hor;
		new_mesg->tjust.ver = msgs->tjust.ver;
	}

	bufpar_("txcolor txcol", "i", (MIXED *)&tx_color);
	DBprintf("storemesg: txcolor: %d %d\n", tx_color, new_mesg->color);
	if(bufpar_("txcolor txcol", "i", (MIXED *)&tx_color) <= 0)
		new_mesg->color = msgs->color;
	else
		new_mesg->color = tx_color;

	if (bufpar_("txfont", "i", (MIXED *)&tx_font))
	{
		new_mesg->font = tx_font;
	}
	else
		new_mesg->font = msgs->font;

	msgs = new_mesg;

	return(msgs);
}

#define ISNUMB(C) ((isdigit(C))||(C=='+')||(C=='-')||(C=='.'))

str_to_num (string, numb, units)
char *string;
float *numb;
int *units;
{
	char *sptr, chr;
	extern char name[];
	for (sptr = string; ISNUMB(*sptr); sptr++)
		;
	if (sptr == string)
	{
		fprintf (stderr, "str_to_num: bad number ", string);
		return (-1);
	}
	chr = *sptr;
	*sptr = '\0';
	*numb = (float) (atof (string));
	switch (chr) {
		case '\0':
			*units = DEFAULT;
			break;
		case 'i':
		case 'I':
			*units = INCH;
			break;
		case 'm':
		case 'M':
			*numb /= 25.4;
			*units = INCH;
			break;
		case 'c':
		case 'C':
			*numb /= 2.54;
			*units = INCH;
			break;
		case 'u':
		case 'U':
		case 'w':
		case 'W':
			*units = USER;
			break;
		default :
			return (-1);
			break;
	}
	return(0);
}
