/*
	scaledata.c - sets minimum and maximum x and y values, from parameters
if given, else discovered from data.  Checks for invalid min or max values,
whether normal or logarithmic.

	Revised 11 July 1991 - Phil Farrell
	Fixed logic bugs.  First was that if ANY of the four limiting
parameters (xmin, xmax, ymin, ymax) was not specified in parameter
file, old version re-initialized all four to values found in data; only
the ones not set in parameter file should be set from actual data.
Second was error checking for logarithmic limits.  If logx is in
effect, data values have already been converted to logs when read; same
for logy.  Previous version did not account for this and attempted to
check limits found in data for value < 0.  Only limits specified in
parameter file should be so checked, because they are not specified as
logs but in native scale.  Third was that previous version adjusted
limits for log case to include whole cycle in every case.  Fixed so
only adjusts limits that are determined from data, not those specified
by user in parameter file, as documented in manual entry.
*/
#include <stdio.h>
#include "gks.h"
#include "graph.h"
static char *ident = "@(#) %M% %I%";

scaledata(nplot, plots, viewport, logx, logy)
int nplot;
struct plotbuf *plots[];
Glimit *viewport;
int logx, logy;
{
	register int ii, jj;
	float xmin, xmax, ymin, ymax;
	int errflag, xmin_set = 0, ymin_set = 0, xmax_set = 0, ymax_set = 0;
	Gpoint *pptr;
	extern double floor(), ceil(), log10();


	errflag = 0;
	if(getpar("xmin","f",&xmin))
	{
		viewport->xmin = xmin;
		++ xmin_set;
		if (logx)
		{
		    if(viewport->xmin <= 0 )
		    {
		    	fprintf(stderr,
				"Input error: xmin <= 0; invalid for logx\n");
		    		errflag =1;
		    }
		    else
			viewport->xmin = (float)log10((double)viewport->xmin);
		}
	}
	else if (nplot == 0)
	{
		fprintf(stderr,"Input error: xmin undefined.\n");
		errflag = 1;
	}

	if(getpar("ymin","f",&ymin))
	{
		viewport->ymin = ymin;
		++ ymin_set;
		if (logy)
		{
		    if(viewport->ymin <= 0 )
		    {
		    	fprintf(stderr,
				"Input error: ymin <= 0; invalid for logy\n");
		    		errflag =1;
		    }
		    else
			viewport->ymin = (float)log10((double)viewport->ymin);
		}
	}
	else if (nplot == 0)
	{
		fprintf(stderr,"Input error: ymin undefined.\n");
		errflag = 1;
	}

	if(getpar("xmax","f",&xmax))
	{
		viewport->xmax = xmax;
		++ xmax_set;
		if (logx)
		{
		    if(viewport->xmax <= 0 )
		    {
		    	fprintf(stderr,
				"Input error: xmax <= 0; invalid for logx\n");
		    		errflag =1;
		    }
		    else
			viewport->xmax = (float)log10((double)viewport->xmax);
		}
	}
	else if (nplot == 0)
	{
		fprintf(stderr,"Input error: xmax undefined.\n");
		errflag = 1;
	}

	if(getpar("ymax","f",&ymax))
	{
		viewport->ymax = ymax;
		++ ymax_set;
		if (logy)
		{
		    if(viewport->ymax <= 0 )
		    {
		    	fprintf(stderr,
				"Input error: ymax <= 0; invalid for logy\n");
		    		errflag =1;
		    }
		    else
			viewport->ymax = (float)log10((double)viewport->ymax);
		}
	}
	else if (nplot == 0)
	{
		fprintf(stderr,"Input error: ymax undefined.\n");
		errflag = 1;
	}

	if((nplot != 0) && ((xmin_set + ymin_set + xmax_set + ymax_set) < 4))
	{
		pptr = plots[0]->pointaddr;
		if (!xmin_set)
		    viewport->xmin = pptr->x;
		if (!ymin_set)
		    viewport->ymin = pptr->y;
		if (!xmax_set)
		    viewport->xmax = pptr->x;
		if (!ymax_set)
		    viewport->ymax = pptr->y;
#ifdef DEBUG
fprintf(stderr, "scaledata: ymax = %f\n", viewport->ymax);
#endif
		for (ii = 0; ii < nplot; ii++)
		{
			pptr = plots[ii]->pointaddr;
			for (jj = 0; jj < plots[ii]->count; jj++)
			{
				if (!xmin_set)
					viewport->xmin = (pptr->x < viewport->xmin) ?
						 pptr->x : viewport->xmin;
				if (!ymin_set)
					viewport->ymin = (pptr->y < viewport->ymin) ?
						 pptr->y : viewport->ymin;
				if (!xmax_set)
					viewport->xmax = (pptr->x > viewport->xmax) ?
						 pptr->x : viewport->xmax;
				if (!ymax_set)
					viewport->ymax = (pptr->y > viewport->ymax) ?
						 pptr->y : viewport->ymax;

#ifdef DEBUG
fprintf(stderr, "scaledata: ymax = %f\n", viewport->ymax);
#endif
				pptr++; 
			}
		}
	}

#ifdef DEBUG
fprintf(stderr, "scaledata: after find min/max values: xmin = %f, xmax = %f, ymin = %f, ymax = %f\n",
	viewport->xmin, viewport->xmax, viewport->ymin, viewport->ymax);
#endif
/*
	If a limit value was not set, AND using logs, force log to whole
cycle.
*/
	if (logx)
	{
		if (! xmin_set)
			viewport->xmin = (float)floor((double)(viewport->xmin));

		if (! xmax_set)
			viewport->xmax = (float)ceil((double)(viewport->xmax));
	}

	if (logy)
	{
		if (! ymin_set)
			viewport->ymin = (float)floor((double)(viewport->ymin));

		if (! ymax_set)
			viewport->ymax = (float)ceil((double)(viewport->ymax));
	}

#ifdef DEBUG
fprintf(stderr, "scaledata: after adjust log cycles: xmin = %f, xmax = %f, ymin = %f, ymax = %f\n",
	viewport->xmin, viewport->xmax, viewport->ymin, viewport->ymax);
#endif
	if(viewport->xmax <= viewport->xmin)
	{
		fprintf(stderr,"Input error: xmax <= xmin\n");
		errflag = 1;
	}
	if(viewport->ymax <= viewport->ymin)
	{
		fprintf(stderr,"Input error: ymax <= ymin\n");
		errflag = 1;
	}

#ifdef DEBUG
fprintf(stderr, "scaledata: end: xmin = %f, xmax = %f, ymin = %f, ymax = %f\n",
	viewport->xmin, viewport->xmax, viewport->ymin, viewport->ymax);
#endif

	if (errflag)
		return(-1);
	else 
		return (0);
}
