#include <stdio.h>
#include <ctype.h>
#include "gks.h"
#include "graph.h"
char *malloc(), *strcpy();
struct mesg *storemesg();
/* MIXED is taken from fastpar.h, in the vplot filters library;
	it should be put into a globally-accessible header file. */
typedef struct { int *i; float *f; double *g; char *s } MIXED;
static char *ident = "@(#) %M% %I%";

#define NOTNUMB(C) ((!isdigit(C)) && (C!='+') && (C!='-') && (C!='.'))
struct _iobuf tbuf;
struct _iobuf *textbuffer = &tbuf;

readdata(infile, plots, messages, logx, logy)
struct infil *infile;
struct plotbuf *plots[];
struct mesg **messages;
int logx, logy;
{
	Gpoint *points, *pptr;
	float symbsc[MAXPLOTS];
	int plotcol[MAXPLOTS], plotfat[MAXPLOTS], linetype[MAXPLOTS];
	int symbol[MAXPLOTS], symbfont[MAXPLOTS];
	/* readdata() is responsible for keeping a running total of data sets
	 * read.  The total (for all files read to date) is returned to the
	 * main program.
	 */
	static int plotsread = 0;
	int textsaved;
	int npts, ii, jj, kk, flag;
	float *farray, *fptr, x0, dx;
	int dataread = 0;
	int errflag = 0;
	char string[81], where[81];
	extern struct _iobuf *textbuffer;
	extern char name[];
	extern double fabs(), log10(), pow();


	/*
	 *  get file format parameters
	 */
	if (infile->lpar[0] != '\0')
	{	sprintf (string, "par=%s", infile->lpar);
		bufpar_add_string (string);
		bufpar_scan(textbuffer->_base, textbuffer->_cnt, 1);
	}

	/*
	 * allocate space and read in the data
	 */

	for (ii=0; ii<infile->nplot; ii++)
	{	textsaved = 0;
		npts = 0;
		bufpar_scan(textbuffer->_base, textbuffer->_cnt, 1);
		if(infile->format == ASCII)							/* ASCII mode */
		{
		/*
		 * rewind the text buffer for bufpar() parameters that may be
		 * interspersed with the data
		 */
			textbuffer->_cnt = 0;
			textbuffer->_ptr = textbuffer->_base;

			if (fgets(string,80,infile->stream) == NULL) break;		/* EOF */
			/* skip leading white space and blank lines */
			for (kk=0; isspace(string[kk]); kk++) ;
			/*
			 * interpret non-numeric data lines:
			 * examine any line whose FIRST non-white character
			 * is not a digit or period
			 */
			if ( NOTNUMB(string[kk]) )
			{	ii--;
				if (string[kk] == '$')
				{	strcpy(where, string);
					if (fgets(string,80,infile->stream) == NULL) break;
						/* EOF */
					*messages = storemesg(where, string, *messages);
				}
				else
				{	textsaved = 1;
					if ((flag = bufcat(textbuffer, string)) < 0) return(flag);
				}
				continue;
			}
			dataread++;
		
			
			/*VARARGS2*/
			sscanf(string,"%d",&npts);
			if ( npts < 0 || npts > MAXPTS)
			{	fprintf(stderr,"%d points in data set %d\n", npts,ii+1);
				fprintf(stderr,"can't handle that...bye!\n");
				return (-1);
			}
			points = (Gpoint *)malloc((unsigned)(npts*sizeof(Gpoint)));
			pptr = points;
			if (infile->increment != 0)		/* ASCII x-increment mode */
			{	if(fgets(string,80,infile->stream)==NULL)
					read_error(ii);
				/*VARARGS2*/
				sscanf(string,"%*d %f %f",&x0,&dx);
				for (jj=0; jj<npts; jj++)
				{	if(fgets(string,80,infile->stream)==NULL)
						read_error(ii);
					for (kk=0; isspace(string[kk]); kk++) ;
					if ( NOTNUMB(string[kk]) )
					{	jj--;
						if (string[kk] == '$')
						{	strcpy(where, string);
							if (fgets(string,80,infile->stream) == NULL) break;
							*messages = storemesg(where, string, *messages);
						}
						else
						{	textsaved = 1;
							if ((flag = bufcat(textbuffer, string)) < 0)
								return (flag);
						}
						continue;
					}
					/*VARARGS2*/
					sscanf(string,"%f",&(pptr->y));
					pptr->x = x0+jj*dx;
					pptr++; 
				}
			}
			else								/* ASCII x, y pairs */
			{	for (jj=0; jj<npts; jj++)
				{	if(fgets(string,125,infile->stream)==NULL)
						read_error(ii);
					for (kk=0; isspace(string[kk]); kk++) ;
					if ( NOTNUMB(string[kk]) )
					{	jj--;
						if (string[kk] == '$')
						{	strcpy(where, string);
							if (fgets(string,80,infile->stream) == NULL) break;
							*messages = storemesg(where, string, *messages);
						}
						else
						{	textsaved = 1;
							if ((flag = bufcat(textbuffer, string)) < 0)
								return (flag);
						}
						continue;
					}
					/*VARARGS2*/
					if(kk = sscanf(string,"%f %f", &pptr->x, &pptr->y) != 2)
					{	fprintf(stderr, "data scanning error\n");
						read_error(ii);
					}

					pptr++; 
				}
			}

		/* scan any text we've collected while reading this data set */
			if (textsaved)
			{	bufpar_scan(textbuffer->_base, textbuffer->_cnt, 1);
				if (bufpar("symbol", "s", (MIXED *)string))
					getsymb (string, symbol);
				bufpar("plotfat fat", "i", (MIXED *)&plotfat[ii]);
				bufpar("symbfont", "i", (MIXED *)&symbfont[ii]);
				bufpar("symbscale", "f", (MIXED *)&symbsc[ii]);
				bufpar("plotcol symbcol", "i", (MIXED *)&plotcol[ii]);
				bufpar("linetype", "i", (MIXED *)&linetype[ii]);
			}
		}

		else													/* binary */
		{	if( (npts = getw(infile->stream)) == EOF) break;
			if (!dataread) dataread++;
			if( npts < 0 || npts > MAXPTS)
			{	fprintf(stderr,"%d  points in data set %d\n",
					npts, ii+1);
				fprintf(stderr,"can't handle that...bye!\n");
				return(-1);
			}
			farray = (float *)malloc((unsigned)(npts*sizeof(float)));
			points = (Gpoint *)malloc((unsigned)(npts*sizeof(Gpoint)));
			if (infile->increment != 0)				/* binary increment mode */
			{	fread((char *)&x0,sizeof(float),1,infile->stream);
				fread((char *)&dx,sizeof(float),1,infile->stream);
				if(fread((char *)farray,sizeof(float),npts,infile->stream)
				    != npts) read_error(ii);
				pptr=points;
				fptr = farray;
				for (jj=0; jj<npts; jj++)
				{	pptr->x = x0+jj*dx;
					pptr->y = *fptr;
					pptr++;
					fptr++;
				}
			}
			else								/* binary: all x, then all y */
			{	if(fread((char *)farray,sizeof(float),npts,infile->stream)
				    != npts) read_error(ii);
				pptr=points;
				fptr = farray;
				for (jj=0; jj<npts; jj++)
				{	pptr->x = *fptr;
					pptr++;
					fptr++;
				}
				if(fread((char *)farray,sizeof(float),npts,infile->stream)
				    != npts) read_error(ii);
				pptr=points;
				fptr = farray;
				for (jj=0; jj<npts; jj++)
				{	pptr->y = *fptr;
					pptr++;
					fptr++;
				}
			}
			free((char *)farray);
		}
		if (dataread)
		{	if (plotsread == MAXPLOTS - 1)
			{
				fprintf(stderr, "%s: Too many plots.", name);
				return(-1);
			}

			/*
		 	 * Take logarithms, if necessary
		 	 */
			pptr=points;
			for(jj=0; jj<npts; jj++)
			{	if (logx)
				{	if (pptr->x <= 0)
					{	fprintf(stderr,
							"Input error: x <= 0 for plot %d, point %d\n",
							ii+1,jj+1);
						errflag = 1;
					}
					else pptr->x = log10(pptr->x);
				}
				if (logy)
				{	if (pptr->y <= 0)
					{	fprintf(stderr,
							"Input error: y <= 0 for plot %d, point %d\n",
							ii+1,jj+1);
						errflag = 1;
					}
					else pptr->y = log10(pptr->y);
				}
				pptr++; 
			}
			plots[plotsread] = (struct plotbuf *)malloc(sizeof(struct plotbuf));
			plots[plotsread]->pointaddr = points;
			plots[plotsread]->count = npts;
			plots[plotsread]->symbol = symbol[ii]>0 ? symbol[ii] : 0;
			plots[plotsread]->symbsc = symbsc[ii]>0 ? symbol[ii] : 1;
			plots[plotsread]->symbfont = symbfont[ii]>0 ? symbfont[ii] : 1;
			plots[plotsread]->plotcol = plotcol[ii]>0 ? plotcol[ii] : 6 - ii%6;
			plots[plotsread]->plotfat = plotfat[ii]>0 ? plotfat[ii] : 1;
			plots[plotsread]->linetype = linetype[ii]>0 ? linetype[ii] : 1;
			++ plotsread;
		}
	}

	if (errflag)
		return(-1);
	else
		return (plotsread);
}
