#include <stdio.h>
#include <ctype.h>
#include "gks.h"
#include "graph.h"
static char *ident = "@(#) %M% %I%";

/* function places a tic value in a character string and
   returns the number of characters */
cntnum (strg,ticval)
float ticval;
char *strg;
{
	sprintf (strg,"%1.5g\0",ticval);
	return(cntchr(strg));
}

/* function returns the number of characters in a string */
cntchr (strg)
char *strg;
{
	int i=0,nc=0; 
	char esc=033;
	while (strg[i] != '\0')
	{
		if (strg[i++]==esc)
			i++;
		else
			nc++;
	}
	return (nc);
}

/* subroutine to determine readable scales for axes
   taken from Algorithm 463 -- Collected Algorithms from CACM */
float vint[4] = { 
	1., 2., 5., 10. };
float sqr[3] = { 
	1.414214, 3.162278, 7.071068 };
getscl (xmin,xmax,n,xminp,xmaxp,dist)
int n;
float xmin,xmax,*xminp,*xmaxp,*dist;
{
	int nal,i,m1,m2;
	float del,fn,fm1,fm2,a,b,al;
	double log10(),fabs(),pow();

	if (xmax <= xmin || n <= 0)
	{
		fprintf (stderr,"bad arguments passed to function getscl\n");
		exit(-1);
	}
	fn = n;

	/* roundoff error tolerance */
	del = .00002;

	/* find approximate interval size a */
	a = (xmax - xmin) / fn;
	al = log10(a);
	nal = al;
	if (a < 1.)
		nal--;

	/* a is scaled into variable named b between 1 and 10 */
	b = a / pow(10.,(double)nal);

	/* the closest permissible value for b is found */
	for (i = 0; i < 3 && b >= sqr[i]; i++);

	/* the interval size is computed */
	*dist = vint[i] * pow (10.,(double)nal);
	fm1 = xmin / *dist;
	m1 = fm1;
	if (fm1 < 0.) m1--;
	if (fabs(m1 + 1. - fm1) < del)
		m1++;

	/* the new minimum and maximum limits are found */
	*xminp = *dist * m1;
	fm2 = xmax / *dist;
	m2 = fm2 + 1.;
	if (fm2 < -1.)
		m2--;
	if (fabs(fm2 + 1. - m2) < del)
		m2--;
	*xmaxp = *dist * m2;

	/* adjust limits to account for roundoff if necessary */
	if (*xminp > xmin)
		*xminp = xmin;
	if (*xmaxp < xmax)
		*xmaxp = xmax;
}

perr(message, a, b, c, d, e)
char *message;
{
	extern char name[];
	char format[256];
	/* emergency GKS close, if necessary */

	fprintf(stderr, "%s: ", name, message);
	fprintf(stderr, message, a, b, c, d, e);
}

read_error(plotnum)
int plotnum;
{
	fprintf(stderr,"Error while reading input file for plot number %d\n",
	plotnum);
	fprintf(stderr,"The input file is probably smaller than expected\n");
	fprintf(stderr,"given the values for nx.\n");
	fprintf(stderr,"Bye!\n");
	exit(-1);
}

getsymb (string, symbol)
char *string;
int symbol[];
{
	char *chr;
	int ii=0;
	chr = string;
	while(*chr)
	{
		if( *chr == '\\') /* the next digit is a GKS polymarker type */
		{	while(isascii(*(++chr)))
			{	/*	Note:  This code eats a character after the last
				 *	digit of the number!  There should be a space there,
				 *	as there is for similar codes in the vplot text
				 * 	routines.
				 */
				if(isdigit(*chr))
				{	symbol[ii] = (symbol[ii] * 10) + (*chr - '0');
				}
				else	
				{	break;
				}
			}
		}
		else if((*chr == ' ')||(*chr == (char)0177))
		{	symbol[ii] = 0;
		}
		else symbol[ii] = *chr;
		ii++; chr++;
		if (ii == MAXPLOTS) break;
	}
	return (ii);
}

to_lower(str)
char *str;
{
	int kk;
	for (kk=0; str[kk]; kk++) 
		if(isascii(str[kk]))
			if (isupper(str[kk]))
				str[kk] = str[kk] + 'a' - 'A';
}

#ifndef DEBUG
DBprintf()	{}
#endif /* DEBUG */
