#include <math.h>
#include <sys/ioctl.h>
struct sgttyb ttystat;
#include <stdio.h>
static char *ident = "@(#) %M% %I%";

#include "gks.h"
#include "gksdevice.h"
#include "graph.h"
#include "graphdoc.h"
extern char *strcpy(), *malloc();

int xargc; 
char **xargv;
char name[81];
Gtxfp fntpr;
Gtxfp *fontprec = &fntpr;

main (argc,argv)
int argc; 
char **argv;
{
	register int ii;
	char string[256], word[80];
	int piped_in, piped_out;
	FILE *out_file;
	int count, intvec[30], symbol[MAXPLOTS];
	char *strvec[MAXINFILES];
	float floatvec[30];
	int numfiles=0;
	float labelsz;
	struct plotbuf *plots[MAXPLOTS];
	struct infil infilpar[MAXINFILES];
	struct mesg *messages, *firstmessage;
	int wstype;
	char typename[80], *ggetwstype(), *cptr;
	Gqloc dummy2;
	int nychrmax;
	float xinch, yinch;
	Glimit window;
	int logx, logy, loglog;
	int plotsread = 0;
#ifdef DEBUG
	int jj, kk;
	Gpoint *pptr;
#endif	/* DEBUG */

	/*
	 * get parameters, open files, and set defaults
	 */
	xargc = argc; 
	xargv=argv;
	strcpy (name, "graph");

	/* 
	 * If no arguments, and not in a pipeline, self document
	 */
	piped_in = ioctl ((int)(fileno (stdin)), TIOCGETP, (char *)&ttystat);
	piped_out = ioctl ((int)(fileno (stdout)), TIOCGETP, (char *)&ttystat);
	if (argc == 1 && !piped_in)
	{
		for ( ii=0; ii<doclength; ii++)
			printf("%s\n",documentation[ii]);
		exit (0);
	}

	/*
	 * process getpar parameters
	 */
	xargc = argc;
	xargv = argv;

	strcpy(string, "graph.error.log");
	getpar("error","s",string);
	if((freopen(string,"w",stderr)) == NULL)
		fprintf(stderr,"cannot open error file %s\n", string);

	/* There's exactly one output file.  Default: standard output stream,
	 * if output is redirected.  Otherwise, output takes the form of
	 * graphics output directly to the workstation.
	 */
	if (getpar("out","s",string)==0)
		out_file=stdout;
	else
	{
		sscanf(string,"%s",word);
		if ((out_file=fopen(word,"w"))==NULL)
		{
			fprintf (stderr,"cannot open output file %s\n",word);
			exit(1);
		}
	}

	/* initialize the input file parameters structures */
	for (ii=0; ii<MAXINFILES; ii++)
	{
		infilpar[ii].format = ASCII;
		infilpar[ii].increment = NO;
		infilpar[ii].nplot = MAXPLOTS;
		infilpar[ii].name[0] = '\0';
		infilpar[ii].lpar[0] = '\0';
	}

	/*
	 * get names of input files
	 */
	if( piped_in )
	{
		sprintf(infilpar[0].name, "sTdIn");
		numfiles ++;
	}
	if (getpar("in input","s",string) > 0)
	{
		count = readline (string, strvec, MAXINFILES);
		for (ii=0; ii<count; ii++)
		{	if (numfiles == MAXINFILES)
			{	err("%s: Too many input files.  File %s ignored.\n",
					name, strvec[ii]);
			}
			else
			{	strcpy(infilpar[numfiles].name, strvec[ii]);
				numfiles ++;
			}
		}
	}
	/*
	 * process input line for non-getpar arguments and assume
	 * they are also input files
	 */
	xargc = argc;
	xargv = argv;
	for (xargc--,xargv++; xargc; xargc--,xargv++)
	{
		cptr = *xargv; 
		if( *cptr=='-' ) continue; /* this is a flag */
		while (*cptr)
		{
			if (*cptr == '=')  break; /* this is for getpar */
			cptr++;
		}       
		if (*cptr)  continue;  /* stopped in the middle of a getpar() flag */
		cptr = *xargv;
		if (numfiles == MAXINFILES)
		{	err("%s: Too many input files.  File %s ignored.\n",
				name, cptr);
		}
		else
		{	strcpy(infilpar[numfiles].name, cptr);
			numfiles ++;
		}
	}

	if (numfiles == 0)
	{	fprintf(stderr, "graph: No input.\n");
		exit(2);
	}

	/* get input file parameters */
	if (count = getpar("increment", "1", intvec))
	{	count = (count > numfiles) ? numfiles : count;
		for (ii=0; ii<count; ii++)
			infilpar[ii].increment = intvec[ii];
	}
	if (count = getpar("format", "s", string))
	{	count = readline (string, strvec, numfiles);
		count = (count > numfiles) ? numfiles : count;
		for (ii=0; ii<count; ii++)
		{	if (strvec[ii][0] == 'b' || strvec[ii][0] == 'B')
				infilpar[ii].format = BINARY;
			else
				infilpar[ii].format = ASCII;
		}
	}
	if (count = getpar("nplot", "i", intvec))
	{	count = (count > numfiles) ? numfiles : count;
		for (ii=0; ii<count; ii++)
			infilpar[ii].nplot = intvec[ii];
	}
	if (count = getpar("lpar", "s", string))
	{
		count = readline (string, strvec, numfiles);
		count = (count > numfiles) ? numfiles : count;
		for (ii=0; ii<count; ii++)
		{
			strcpy(infilpar[ii].lpar, strvec[ii]);
		}
	}

	logx = NO;
	getpar("logx","1",&logx);
	logy = NO;
	getpar("logy","1",&logy);
	loglog = NO;
	getpar("loglog","1",&loglog);
	if (loglog)
	{
		logx = YES;
		logy = YES;
	}

	/*
	 * initialize the buffer for user-defined labels
	 */

	messages = (struct mesg *) malloc ((unsigned)sizeof(struct mesg));
	messages->location.x = 0.0;
	messages->location.y = 0.0;
	messages->locunits.x = INCH;
	messages->locunits.y = INCH;
	messages->size = 0.20;
	messages->sizeunits = INCH;
	messages->orient = 0.0;
	messages->tjust.hor = GTH_NORMAL;
	messages->tjust.ver = GTV_NORMAL;
	messages->color = 7;
	messages->string[0] = '\0';
	messages->font = 1;
	messages->prev = (struct mesg *)NULL;
	messages->next = (struct mesg *)NULL;
	firstmessage = messages;

	/*
	 * read the input files
	 */
	ii = 0;
	if (!strcmp(infilpar[0].name, "sTdIn"))
	{	infilpar[0].stream = stdin;
		ii++;
/* BUG ALERT:  This stdin code won't be used properly in the
 * next do/while block.
 */
	}
	/* Open each input file, and read its data into plot, message, and infil
	 * structures.
	 */
	do		/* Loop over all the input file names. */
	{
		if ((infilpar[ii].stream = fopen (infilpar[ii].name, "r")) == NULL)
		{	fprintf(stderr,"%s: cannot open input file %s\n",
				name,infilpar[ii].name);
			exit (3);
		}
		if ((plotsread = readdata(&infilpar[ii], plots,
				&messages, logx, logy)) == -1)
		{	fprintf (stderr, "%s: Input error while reading file %s\n",
				name, infilpar[ii].name);
			exit (4);
		}
	}
	while (++ii < numfiles);

	if (plotsread == 0 && messages == firstmessage)
	{	fprintf(stderr, "%s: No data read; exiting.\n", name);
		exit(6);
	}

	/* get data set parameters */
	/* Use par file and command line arguments to override whatever
	 * was set in lpar files and data files.
	 */
	if (count = getpar("symbol", "s", string))
	{	count = getsymb (string, symbol);
		for (ii=0; ii<count,ii<plotsread; ii++)
			plots[ii]->symbol = symbol[ii];
	}
	if (count = getpar("symbscale", "f", floatvec))
		for (ii=0; ii<count,ii<plotsread; ii++)
			plots[ii]->symbsc = floatvec[ii];
	if (count = getpar("symbfont", "d", intvec))
		for (ii=0; ii<count,ii<plotsread; ii++)
			plots[ii]->symbfont = intvec[ii];
	if (count = getpar("plotcol", "d", intvec))
		for (ii=0; ii<count,ii<plotsread; ii++)
			plots[ii]->plotcol = intvec[ii];
	if (count = getpar("plotfat", "f", floatvec))
		for (ii=0; ii<count,ii<plotsread; ii++)
			plots[ii]->plotfat = floatvec[ii];
	if (count = getpar("linetype", "d", intvec))
		for (ii=0; ii<count,ii<plotsread; ii++)
			plots[ii]->linetype = intvec[ii];

#ifdef DEBUG
 	for(kk=0; kk< plotsread; kk++)
 	{	fprintf(stderr,"plot %d: %d points\n", kk, plots[kk]->count);
 		fprintf(stderr,"symbol=%d\n", plots[kk]->symbol);
 		fprintf(stderr,"symbscale=%f\n", plots[kk]->symbsc);
 		fprintf(stderr,"symbfont=%d\n", plots[kk]->symbfont);
 		fprintf(stderr,"plotcol=%d\n", plots[kk]->plotcol);
 		fprintf(stderr,"plotfat=%d\n", plots[kk]->plotfat);
 		fprintf(stderr,"linetype=%d\n", plots[kk]->linetype);
 		pptr = plots[kk]->pointaddr;
 		for (jj=0; jj<plots[kk]->count; ++jj)
 		{
 			fprintf(stderr,"main: %f %f\n", (pptr)->x, pptr->y);
 			pptr++;
 		}
	}
#endif	/* DEBUG */

	/*
	 * initialization for plotting
	 */
	strcpy(typename, ggetwstype(out_file));
	if(((wstype = gwstype(typename)) == 0) && !(piped_out))
	{
		fprintf(stderr, "graph: Unknown workstation type.\n");
		fprintf(stderr, "       Set the WSTYPE environment variable,");
		fprintf(stderr, " or redirect your output.\n");
		exit(5);
	}

	if (scaledata(plotsread, plots, &window, logx, logy) < 0)
		exit(7);

#ifdef DEBUG
fprintf(stderr, "main(): after scaledata: xmin=%f, xmax=%f, ymin=%f, ymax=%f\n",
	window.xmin, window.xmax, window.ymin, window.ymax);
#endif

	/* set up for graphics */
	gopengks(1000,stderr);
	gopenws(WORKSTATION,out_file,typename);
	gactivatews(WORKSTATION);

	/* do the graphics stuff */

	/* this will depend on the font chosen by the user */
	if(wstype == VPLOT)
	{
		fontprec->font = 1;
		fontprec->prec = GSTROKE;
	}
	else
	{
		fontprec->font = 1;
		fontprec->prec = GSTRING;
	}

	labelsz = 0.20;
	getpar("lablsz", "f", &labelsz);
	xinch=8.0; 
	getpar("xinch","f",&xinch);
	yinch=4.0; 
	getpar("yinch","f",&yinch);
#ifdef DEBUG
fprintf(stderr, "main(): before doaxes: xmin=%f, xmax=%f, ymin=%f, ymax=%f\n",
	window.xmin, window.xmax, window.ymin, window.ymax);
#endif
	nychrmax = doaxes(xinch, yinch, &window, typename, logx, logy, labelsz);
	dolabels(xinch, yinch, nychrmax);
	doplots(plotsread, plots);
	if(firstmessage->next != (struct mesg *)NULL)
		domessages(firstmessage->next, &window, logx, logy);

	/* wait for a carriage return */
	if(wstype != VPLOT) greqloc(WORKSTATION, 1, &dummy2);

	/* shut it all down */
	gdeactivatews(WORKSTATION);
	gclosews(WORKSTATION);

	exit(0);
}
