/* @(#) %M% %I% */
/*
 * graph - create XY data plots 
 *
 * Authors: Dave Hale, 11/2/82
 *          Glenn Kroeger 12/25/83
 *
 * Log scales added by Chuck Karish, 7/5/85, based on a preliminary
 *          implementation by an anonymous petroleum engineer.
 *
 * GKS converted by Glenn Kroeger  8/15/85
 *
 * 1/25/86: Added loop to ignore comment lines and parameter lines
 *          which begin with non-digits, to allow embedded parameters
 *          and comments at breaks between plots.  Also added
 *          "error=" parameter, and error catching for
 *          window->ur.[xy] == window->ll.[xy].               --crk
 *
 * 3/5/86:      Added test for d[xy]num <= 0 to avoid infinite loops. --crk
 *
 * 10/10/86:    Call GKS to open the terminal as a workstation, if
 *               output is not redirected.  Depends on /etc/ttywstypes
 *               or WSTYPE environment variable.               --crk
 */
char *documentation[] = {
" NAME",
"     graph - create XY data plots (outputs VPLOT)",
" SYNOPSIS",
"     graph [data reading options] [data display options] [axis options]",
" OPTIONS",
"     data reading     |   data display       |    axes ",
"    ------------------|----------------------|---------------------",
"     x=string         |    symbol=string     | xinch,yinch=float",
"     format=string    |    symbscale=float   | xmin,xmax,ymin,ymax=float",
"     in=filename      |    plotfat=int       | dxnum,dynum=float",
"     out=filename     |    plotcol=int       | x0num,y0num=float",
"     nplot=int        |    linetype=int      | nxtic,nytic=int",
"                      |    logx,logy=int     | box,grid=int",
"                      |    loglog=int        | axiscol,axisfat=int",
"                      |                      | gridcol,gridfat=int",
"                      |                      | title,xlabel,ylabel=string",
"                      |                      | titlsz,lablsz,numsz=float",
"                      |                      | titlcol,lablcol,numcol=int",
"                      |                      | titlfat,lablfat,numfat=int",
"From Ethernet terminals, 'setenv WSTYPE terminal type' (graphon, tek4107, etc.)",
" SEE ALSO",
"     graph(L), gks(L), vplot(L), /etc/ttywstypes"
};
int     doclength = { sizeof documentation/sizeof documentation[0] };

