/*
 *	error termination subroutine
 *	a is a printf format string, while b-h are optional arguments
 *	When the subroutine is called, the program will stop after
 *	printing its message.
 *	Example:	err("Cannot divide %f by %f\n", x, y);
 *
 *      Also has Fortran companion routines err_(string) and erexit_(string)
 *
 * Revised  4/23/84    stew     echo to stdout (header) as well
 * Revised  9/7/87     stew	<varargs> for portability
 * Revised  9/16/88    jclau    fvprintf instead to vprintf.
 * Modified 6/23/89  Dave Nichols 
 *	   added xargfix call to fix up external variables
 * Revised 2 July 90 Phil Farrell - automatically define XARGFIX and ULTRIX
 *         for Digital RISC ULTRIX machines (DECstation, DECsystem).
 */
#include <stdio.h>
#include <varargs.h>
static char *err_ident = "@(#) %M% %I%";

/* 
   On Digital RISC ULTRIX machines, compiler automatically defines MIPSEL
   flag, so use this to define XARGFIX and ULTRIX for these machines if
   not already defined.
*/
#ifndef XARGFIX
#ifdef MIPSEL
#define XARGFIX
#endif
#endif
#ifndef ULTRIX
#ifdef MIPSEL
#define ULTRIX
#endif
#endif

/*VARARGS0*/
err(va_alist)
va_dcl
{
	va_list args;
	char *format;
	extern char **xargv;

#ifdef XARGFIX
	extern void xargfix();
	xargfix();
#endif

	va_start(args);

/*----- stderr -----*/

        /* print out name of program causing error */
	if( xargv ) fprintf( stderr, "%s: ", xargv[0] );

	format = va_arg(args,char *);

        /* print out remainder of message */
#if defined(SUN) || defined(ULTRIX)
	vfprintf( stderr, format, args );
#else
	_doprnt( format, args, stderr);
#endif
	fflush(stderr);

/*----- stdout -----*/

        /* print out name of program causing error */
	if( xargv ) fprintf( stdout, "%s: ", xargv[0] );

        /* print out remainder of message */
#if defined(SUN) || defined(ULTRIX)
	vfprintf( stdout, format, args );
#else
	_doprnt( format, args, stdout);
#endif
	fflush(stdout);

	va_end(args);
	exit(-1);
}
