#include <math.h>
#include <stdio.h>
#include "gks.h"
#include "graph.h"
#define PI 3.1415926535898
extern Gtxfp *fontprec;
extern char *name;
static char *ident = "@(#) %M% %I%";

domessages(msgptr, viewport, logx, logy)
struct mesg *msgptr;
Glimit *viewport;
int logx, logy;
{
	Gwstran utran, itran;
	float xscale, yscale;
	Gtxfp curfontprec;
	struct mesg *curmesg;
	float orient;
	Gpoint up;
	extern double log10();

	/*
	 * display user-defined messages
	 */
	gselntran(INCH);
	ginqntran(INCH, &itran);
	gselntran(USER);
	ginqntran(USER, &utran);
	/* get scale factors to change inches to user units */
	xscale = (utran.w.xmax - utran.w.xmin)*(itran.v.xmax - itran.v.xmin)/
		((utran.v.xmax-utran.v.xmin)*(itran.w.xmax - itran.w.xmin));
	yscale = (utran.w.ymax - utran.w.ymin)*(itran.v.ymax - itran.v.ymin)/
		((utran.v.ymax-utran.v.ymin)*(itran.w.ymax - itran.w.ymin));

	gsetclip(GNOCLIP);

	curmesg = msgptr;
	while (curmesg != (struct mesg *)NULL)
	{
		orient = DEG_TO_RAD(curmesg->orient);
		/*
		 * this charup code only works for path = RIGHT
		 */
		up.x = (float)cos((double)(orient+PI/2));
		up.y = (float)sin((double)(orient+PI/2));

		/*
		 * If the message location is in USER units (not INCH)
		 * and it's a logarithmic plot, take the log of the location.
		 */
		if (logx && (curmesg->locunits.x != INCH))
		{
			if (curmesg->location.x <= 0.)
			{
				fprintf(stderr,
					"%s: domessages(): curmesg->location.x <= 0.", name);
				fprintf(stderr,
					"%s: domessages(): Message not printed.", name);
				continue;
			}
			curmesg->location.x = (float)log10((double)curmesg->location.x);
		}

		if (logy && (curmesg->locunits.y != INCH))
		{
			if (curmesg->location.y <= 0.)
			{
				fprintf(stderr,
					"%s: domessages(): curmesg->location.y <= 0.", name);
				fprintf(stderr,
					"%s: domessages(): Message not printed.", name);
				continue;
			}
			curmesg->location.y = (float)log10((double)curmesg->location.y);
		}

		/*
		 * If the message is located in USER units, interpret the
		 * location as (x, y) coordinates on the graph.  Otherwise
		 * the location is in length units (inches or cm) from the
		 * lower left corner of the graph.
		 */
		if (curmesg->locunits.x == USER)
			curmesg->location.x -= viewport->xmin;
		if (curmesg->locunits.y == USER)
			curmesg->location.y -= viewport->ymin;

		/*
		 * We may want to use one normalization transformation for
		 * location, and a different one for character size.  We'll
		 * convert the location units so they're appropriate for
		 * the transformation needed to fix the size properly.
		 * Then GKS will scale the size properly for all orientations
		 * of text.
		 */
		switch (curmesg->sizeunits)
		{
			case USER:
				if (curmesg->locunits.x == INCH)
					curmesg->locunits.x *= xscale;
				if (curmesg->locunits.y == INCH)
					curmesg->locunits.y *= yscale;
				/*
				 * The following two lines are needed to get proper
				 * orientation when xscale != yscale.  It produces
				 * character heights in y units, as if the text were
				 * horizontal.  Without this code, the text size is 
				 * scaled for the correct orientation, but the text
				 * is actually drawn in an unexpected orientation.
				 */
				up.x /= xscale;
				up.y /= yscale;
				gselntran(USER);
				break;
			case DEFAULT:
			case INCH:
			default:
				if (curmesg->locunits.x == DEFAULT ||
					curmesg->locunits.x == USER)
					curmesg->location.x /= xscale;
				if (curmesg->locunits.y == DEFAULT ||
					curmesg->locunits.y == USER)
					curmesg->location.y /= yscale;
				gselntran(INCH);
				break;
		}

		gsetcharup(&up);
		gsetcharheight(curmesg->size);
		gsettextalign(&(curmesg->tjust));
		gsettextcolourind(curmesg->color);
		curfontprec.font = curmesg->font + 1;
		curfontprec.prec = fontprec->prec;
		gsettextfontprec(&curfontprec);
		if (curmesg->string != NULL)
			gtext(&curmesg->location, curmesg->string);
		curmesg = curmesg->next;
	}
}
