#include "gks.h"
#include <stdio.h>
static char *ident = "@(#) %M% %I%";

dolabels(xinch, yinch, nychrmax)
float xinch, yinch;
int nychrmax;
{
	char xlabel[100], ylabel[100], title[100];
	float lablsz, titlsz, numsz;
	int lablcol, titlcol, ii, savefont;
	Gpoint vector;
	Gpoint *vec = &vector;
	Gtxalign algn;
	Gtxalign *align = &algn;
	extern Gtxfp *fontprec;

	xlabel[0] = ylabel[0] = title[0] = '\0';
	getpar("xlabel","s",xlabel);
	getpar("ylabel","s",ylabel);
	getpar("title","s",title);
	lablsz=0.2; 
	getpar("lablsz","f",&lablsz);
	lablcol = 7; 
	getpar("lablcol","d",&lablcol);
	titlsz=0.3; 
	getpar("titlsz","f",&titlsz);
	titlcol = 7; 
	getpar("titlcol","d",&titlcol);
	numsz = 0.15;
	getpar("numsz","f",&numsz);

	savefont = fontprec->font;

	if (getpar("lablfont", "d", &ii))
		fontprec->font = ii + 1;
	else if (getpar("font txfont", "d", &ii))
	{	savefont = ii + 1;
		fontprec->font = ii + 1;
	}

	gsetclip(GNOCLIP);		/* Turn off clipping; labels are outside window */

	gsettextfontprec(fontprec);

	if (lablsz > 0)
	{	gsetcharheight(lablsz);
		gstxci(lablcol);

		/*
		 * do y label
		 */
		if (ylabel != (char *)0)
		{	vec->x = -1.; vec->y = 0.;
			gsetcharup(vec);
			align->hor = GTH_CENTER; align->ver = GTV_BOTTOM;
			gsettextalign(align);
			vec->y = yinch/2.; 
			vec->x = -(((nychrmax+1.) * numsz) + lablsz);
			gtext(vec,ylabel);
		}

		/*
		 * do x label
		 */
		if (xlabel != (char *)0)
		{	vec->x = 0.; vec->y = 1.;
			gsetcharup(vec);
			align->hor = GTH_CENTER; align->ver = GTV_TOP;
			gsettextalign(align);
			vec->x = xinch/2.; 
			vec->y = -(lablsz + (2. * numsz));
			gtext(vec,xlabel);
		}
	}

	/*
	 * plot title
	 */

	if (getpar("titlfont", "d", &ii))
		fontprec->font = ii + 1;
	else if (getpar("font txfont", "d", &ii))
		fontprec->font = ii + 1;
	else
		fontprec->font = savefont;

	gsetcharheight(titlsz);
	gsettextfontprec(fontprec);
	align->hor = GTH_CENTER; align->ver = GTV_BOTTOM;
	gsettextalign(align);
	gstxci(titlcol);
	vec->y = yinch + titlsz;
	if (titlsz > 0 ) gtext(vec,title);

	fontprec->font = savefont;
}
