#include <stdio.h>
#include "gks.h"
#include "graph.h"
static char *ident = "@(#) %M% %I%";

doaxes(xinch, yinch, window, typename, logx, logy, lablsz)
float xinch, yinch, lablsz;
Glimit *window;
char *typename;
int logx, logy;
{
	float xscale,yscale;
	float xneeded=0,yneeded=0;
	float dxtic,dytic,x0tic,y0tic,dummy;
	float dxnum,dxbuf,x0num,dynum,dybuf,y0num,xnum,ynum,xtic,ytic;
	float xorig=0,yorig=0;
	float pagelength,ticlength;
	float numsz;
	int nxtic,nytic,nchr,ii;
	int axiscol[2],axisfat[2];
	int numcol, nychrmax;
	int grid,box,gridcol[2],gridfat[2];
	int x_start,x_end,cycle_index,cycle_range,x_tic;
	int y_start,y_end,y_tic,ntic;
	char string[100];
	Glimit pg;
	Glimit *page = &pg;
	Gpoint vector;
	Gdspsize scrnsz;
	Gpoint *vec = &vector;
	Gpoint tick1[2],tick2[2];
	Gtxalign algn;
	Gtxalign *align = &algn;
	extern Gtxfp *fontprec;
	extern double fabs(), pow(), log10();

#ifdef DEBUG
fprintf(stderr, "doaxes(): xmin=%f, xmax=%f, ymin=%f, ymax=%f\n",
	window->xmin, window->xmax, window->ymin, window->ymax);
#endif
	if(logx && logy)
	{
		dummy = window->ymin + (window->xmax - window->xmin)*(yinch)/(xinch);
		if( dummy > window->ymax )
		{
			window->ymax = dummy;
		}
		else
		{
			window->xmax = window->xmin +
				(window->ymax - window->ymin) * (xinch)/(yinch);
		}
	}

#ifdef DEBUG
fprintf(stderr, "doaxes(): xmin=%f, ymin=%f, xmax=%f, ymax=%f\n",
		window->xmin,window->ymin,window->xmax,window->ymax);
#endif
	getscl(window->xmin,window->xmax,(int)((xinch)*0.75),&dummy,&dummy,&dxbuf);
	getpar("dxnum","f",&dxbuf);
	if(dxbuf > 0.) dxnum = dxbuf;
	else
	{
		fprintf (stderr,"input error: dxnum <= 0\n");
		exit(-1);
	}
	for (x0num=(int)((window->xmin)/dxnum)*dxnum-dxnum; x0num<(window->xmin);
				x0num+=dxnum);
	getpar("x0num","f",&x0num);

	getscl(window->ymin,window->ymax,(int)((yinch)*0.75),&dummy,&dummy,&dybuf);
	getpar("dynum","f",&dybuf);
	if(dybuf > 0.) dynum = dybuf;
	else
	{
		fprintf (stderr,"input error: dynum <= 0\n");
		exit(-1);
	}

	for (y0num=(int)((window->ymin)/dynum)*dynum-dynum; y0num<(window->ymin);
				y0num+=dynum);
	getpar("y0num","f",&y0num);
	nxtic = 1; 
	getpar("nxtic","d",&nxtic);
	nytic = 1; 
	getpar("nytic","d",&nytic);
	numsz=0.20; 
	getpar("numsz","f",&numsz);
	dxtic = dxnum/nxtic;
	for (x0tic=x0num-nxtic*dxtic; x0tic<(window->xmin); x0tic+=dxtic);
	dytic = dynum/nytic;
	for (y0tic=y0num-nytic*dytic; y0tic<(window->ymin); y0tic+=dytic);

	/*
	 * setup axes grid and labels
	 */
	grid=0;  
	getpar("grid","d",&grid);
	gridcol[0] = 7; 
	gridcol[1] = 7;  
	getpar("gridcol","d",gridcol);
	gridfat[0] = 0; 
	gridfat[1] = 0;  
	getpar("gridfat","d",gridfat);
	box=1;  
	getpar("box","1",&box);
	axiscol[0] = 7; 
	axiscol[1] = -5; 
	getpar("axiscol","d",axiscol);
	if (axiscol[1] == -5) axiscol[1] = axiscol[0];
	numcol = axiscol[0]; 
	getpar("numcol","d",&numcol);
	axisfat[0] = 0; 
	axisfat[1] = -5; 
	getpar("axisfat","d",axisfat);
	if (axisfat[1] == -5) axisfat[1] = axisfat[0];

	/*
	 * figure out longest Y axis number for origin setting
	 */
	y_start = (int)(window->ymin);
	y_end = (int)(window->ymax);
	nychrmax = 0;
	if (logy) {
		y0num = (float)(y_start);
		ntic = y_end - y_start + 1;
		dynum = 1.;
	}
	else {
		ntic = (int)(((window->ymax - y0num)/dynum)) + 1.;
	}
	ynum = y0num;
	while(ntic--)
	{
		if (fabs((double)ynum)<(window->ymin - window->ymax)/10000) ynum=0.0;
		if (logy)
			nchr = cntnum(string,(float)pow(10.,(double)ynum));
		else nchr = cntnum(string,ynum);
		if ( nchr > nychrmax ) nychrmax = nchr;
		ynum += dynum;
	}

	/*
	 * try to center in 8.5x11 page 
	 * if can't center, just leave 0.3 inch on lower left
	 * so the printer doesn't clip the image
	 */
	xneeded =  (2.0 * lablsz) + ((nychrmax+2) * numsz);
	xorig = 0.3 + xneeded + (PAGELENGTH - xinch - xneeded)/2.0;
	if(xorig < (xneeded + 0.3)) xorig=xneeded + 0.3;
	getpar("xorigin","f",&xorig);
	yneeded =  2. * (numsz + lablsz);
	yorig = 0.3 + yneeded + (PAGEWIDTH - yinch - yneeded)/2.0;
	if(yorig < (yneeded + 0.3)) yorig=yneeded + 0.3;
	getpar("yorigin","f",&yorig);

	page->xmin = 0.;
	page->ymin = 0.;
	page->xmax = (xinch + 2. * xorig);
	page->ymax = (yinch + 2. * yorig);
	/* normalize to long dimension of page */
	pagelength = (page->xmax > page->ymax) ? page->xmax : page->ymax;
	page->xmax /= pagelength;
	page->ymax /= pagelength;
	gsetwswindow(WORKSTATION,page);		/* in NDC space */

	ginqmaxdisplaysize(typename,&scrnsz);
	/*
	 * if possible do absolute scaling
	 */
	if(scrnsz.units == GDC_METERS)
	{
		page->xmax *= (pagelength * .0254);
		page->ymax *= (pagelength * .0254);
		gsetwsviewport(WORKSTATION,page);	/* in meters, device coords. */
	}

	/* Set the displayable window to an xinch x yinch rectangle */
	/* User units are inches for now, while we draw the axes */
	page->xmax = xinch;
	page->ymax = yinch;
	gsetwindow(INCH,page);		/* in user space: world coordinates */

	/* Scale the window to normalized device coordinates */
	page->xmin = xorig/pagelength;
	page->ymin = yorig/pagelength;
	page->xmax = (xinch + xorig)/pagelength;
	page->ymax = (yinch + yorig)/pagelength;
	gsetviewport(INCH,page);	/* in NDC; NDC end of normalization trans. */
	gsetviewport(USER,page);	/* in NDC; NDC end of normalization trans. */

	gsetwindow(USER,window);		/* in user space: world coordinates */
	xscale = xinch/(window->xmax - window->xmin);
	yscale = yinch/(window->ymax - window->ymin);

	gselntran(INCH);
	gsetclip(GNOCLIP);	/* we're going to put numbers outside the viewport */

	/*
	 * establish a reasonable tick size
	 */
	ticlength = ((xinch < yinch) ? xinch : yinch)/30.;
	if(ticlength < 0.10) ticlength = 0.10;

	/*
	 * plot and label y-axis
	 */
	tick1[0].x = 0.;

	/*
	 * first do minor grid or ticks
	 */
	if(grid < 2)
	{
		gsetlinewidth((float)(axisfat[1]+1));
		gsplci(axiscol[1]);
		tick1[1].x = ticlength/2.;
		tick2[1].x = xinch - ticlength/2.;
		tick2[0].x = xinch;
	}
	else
	{
		gsetlinewidth((float)(gridfat[1]+1));
		gsplci(gridcol[1]);
		tick1[1].x = xinch;
	}

	/*
	 * if logy do log cycles on y axis
	 */
	if(logy) 
	{
		cycle_index = 0;
		cycle_range = abs(y_end - y_start);
		ytic = (float)(y_start);
		for (y_tic=1; ; )
		{
			ytic = (float)log10((double)(y_tic)) + (float)(cycle_index);
			if (ytic > cycle_range) break;
			ytic = ytic + y_start;
			tick1[0].y = tick1[1].y = (ytic - window->ymin) * yscale;
			if(y_tic != 1) gpolyline(2,tick1);
			if(box && (grid < 2))
			{
				tick2[0].y = tick2[1].y = tick1[0].y;
				if(y_tic != 1) gpolyline(2,tick2);
			}
			y_tic++;
			if (y_tic == 10)
			{
				cycle_index++;
				y_tic = 1;
			}
		}
	}
	else
	{
		ntic = (int)(((window->ymax - y0tic)/dytic)) + 1.;
		ytic = y0tic;
		while(ntic--)
		{
			tick1[0].y = tick1[1].y = (ytic - window->ymin) * yscale;
			gpolyline(2,tick1);
			if(box && (grid < 2))
			{
				tick2[0].y = tick2[1].y = tick1[0].y;
				gpolyline(2,tick2);
			}
			ytic += dytic;
		}
	}

	/*
	 * now do numbered grid or ticks
	 */
	gstxci(numcol);
	if (getpar("numfont", "i", &ii))
		fontprec->font = ii + 1;
	else if (getpar("font txfont", "i", &ii))
		fontprec->font = ii + 1;
	gsettextfontprec(fontprec);
	align->hor = GTH_RIGHT; align->ver = GTV_HALF;
	gsettextalign(align);
	gsetcharheight(numsz);
	vec->x = -(numsz);
	if(grid)
	{
		gsetlinewidth((float)(gridfat[0]+1));
		gsplci(gridcol[0]);
		tick1[1].x = xinch;
	}
	else
	{
		gsetlinewidth((float)(axisfat[1]+1));
		gsplci(axiscol[1]);
		tick1[1].x = ticlength;
		tick2[1].x = xinch - ticlength;
		tick2[0].x = xinch;
	}
	if (logy) {
		y0num = (float)(y_start);
		ntic = y_end - y_start + 1;
		dynum = 1.;
	}
	else {
		ntic = (int)(((window->ymax - y0num)/dynum)) + 1.;
	}
	ynum = y0num;
	while(ntic--)
	{
		if (fabs((double)ynum)<(window->ymin - window->ymax)/10000) ynum=0.0;
		if (logy)
			nchr = cntnum(string,(float)pow(10.,(double)ynum));
		else nchr = cntnum(string,ynum);
		vec->y = tick1[0].y = tick1[1].y = (ynum - window->ymin) * yscale;
		gpolyline(2,tick1);
		if(box && (!grid))
		{
			tick2[0].y = tick2[1].y = tick1[0].y;
			gpolyline(2,tick2);
		}
		if (numsz > 0) gtext(vec,string);
		ynum += dynum;
	}

	/*
	 *  plot and label x-axis
	 */
	tick1[0].y = 0;

	/*
	 * first do minor grid or ticks
	 */
	if(grid < 2)
	{
		gsetlinewidth((float)(axisfat[1]+1));
		gsplci(axiscol[1]);
		tick1[1].y = ticlength/2.;
		tick2[1].y = yinch - ticlength/2.;
		tick2[0].y = yinch;
	}
	else
	{
		gsetlinewidth((float)(gridfat[1]+1));
		gsplci(gridcol[1]);
		tick1[1].y = yinch;
	}

	/*
	 * if logx do log cycles on x axis
	 */
	if (logx) 
	{
		x_start = (int)(window->xmin);
		x_end = (int)(window->xmax);
		cycle_index = 0;
		cycle_range = abs(x_end - x_start);
		xtic = (float)(x_start);
		for (x_tic=1; ; )
		{
			xtic = (float)log10((double)(x_tic)) + (float)(cycle_index);
			if (xtic > cycle_range) break;
			xtic = xtic + x_start;
			tick1[0].x = tick1[1].x = (xtic - window->xmin) * xscale;
			if(x_tic != 1) gpolyline(2,tick1);
			if(box && (grid < 2))
			{
				tick2[0].x = tick2[1].x = tick1[0].x;
				if(x_tic != 1) gpolyline(2,tick2);
			}
			x_tic++;
			if (x_tic == 10)
			{
				cycle_index++;
				x_tic = 1;
			}
		}
	}
	else
	{
		ntic = (int)(((window->xmax - x0tic)/dxtic)) + 1.;
		xtic = x0tic;
		while(ntic--)
		{
			tick1[0].x = tick1[1].x = (xtic - window->xmin) * xscale;
			gpolyline(2,tick1);
			if(box && (grid < 2))
			{
				tick2[0].x = tick2[1].x = tick1[0].x;
				gpolyline(2,tick2);
			}
			xtic += dxtic;
		}
	}

	/*
	 * now do numbered grid or ticks
	 */
	gstxci(numcol);
	gsettextfontprec(fontprec);
	align->hor = GTH_CENTER; align->ver = GTV_CAP;
	gsettextalign(align);
	gsetcharheight(numsz);
	vec->y = -numsz;
	if(grid)
	{
		gsetlinewidth((float)(gridfat[0]+1));
		gsplci(gridcol[0]);
		tick1[1].y = yinch;
	}
	else
	{
		gsetlinewidth((float)(axisfat[1]+1));
		gsplci(axiscol[1]);
		tick1[1].y = ticlength;
		tick2[1].y = yinch - ticlength;
		tick2[0].y = yinch;
	}
	if (logx) {
		x0num = (float)(x_start);
		ntic = x_end - x_start + 1;
		dxnum = 1.;
	}
	else {
		ntic = (int)(((window->xmax - x0num)/dxnum)) + 1.;
	}
	xnum = x0num;
	while(ntic--)
	{
		if (fabs((double)xnum)<(window->xmin - window->xmax)/10000) xnum=0.0;
		if (logx)
			nchr = cntnum(string,(float)pow(10.,(double)xnum));
		else nchr = cntnum(string,xnum);
		vec->x = tick1[0].x = tick1[1].x = (xnum - window->xmin) * xscale;
		gpolyline(2,tick1);
		if(box && (!grid))
		{
			tick2[0].x = tick2[1].x = tick1[0].x;
			gpolyline(2,tick2);
		}
		if (numsz > 0) gtext(vec,string);
		xnum += dxnum;
	}

	/*
	 * draw plot frame
	 */
	gselntran(INCH);
	gsetclip(GNOCLIP);
	gsplci(axiscol[0]);
	gsetlinetype(1);
	gsetlinewidth((float)(axisfat[0]+1));
	tick1[0].x = 0.; tick1[0].y = 0.;
	tick1[1].x = 0.; tick1[1].y = yinch;
	gpolyline(2,tick1);
	tick1[1].x = xinch; tick1[1].y = 0.;
	gpolyline(2,tick1);
	if(box)
	{
		tick1[0].x = xinch; tick1[0].y = yinch;
		gpolyline(2,tick1);
		tick1[1].x = 0.; tick1[1].y = yinch;
		gpolyline(2,tick1);
	}

	return (nychrmax);
}
