/*
 * bufcat.c: concatenate strings to a text buffer, allocating memory
 * 				as needed.  textbuf should NOT have memory allocated
 *				on first call.
 *
 *		calling parameters:
 *				textbuf: pointer to the buffer
 *				textlen:	number of bytes of data currently in buffer
 *				textmem:	amount of memory currently allocated for buffer
 *				string:		the string to be added to the buffer
 *
 *		C. Karish, Stanford Earth Sciences, 30 December 1986
 	Aug 1990 - Pet Eng folks fixed to use a local MYFILE structure,
		rather than trying to use the stdio FILE structure for
		local use.  The stdio FILE structure is not portable and
		did not work correctly on the Apollo.
 */

static char *ident = "@(#) %M% %I%";
#define BLOCKSIZE 990

typedef struct MYFILE {
	int	cnt;
	char	*ptr;
	char	*base;
	int	bufsiz;
	short	_flag;
	char	_file;
} MYFILE;

#include <strings.h>
#include <stdio.h>
extern char *malloc(), *realloc();

bufcat (textbuf, string)
MYFILE *textbuf;
register char *string;
{
	register int len, ii;
	extern int errno;
	char *tptr;

	len = strlen(string);
	if (textbuf->cnt == 0)
	{
		textbuf->base = malloc (BLOCKSIZE);
		textbuf->bufsiz = BLOCKSIZE;
	}
	while ((textbuf->cnt + len + 1) >= (textbuf->bufsiz))
	{
		textbuf->base = realloc ((char *) textbuf->base,
			(unsigned)(textbuf->bufsiz + BLOCKSIZE));
		if (textbuf->base == NULL)
		{
			/*VARARGS2*/
			fprintf(stderr, "bufcat: couldn't add memory\n");
			return(errno);
		}
		textbuf->bufsiz += BLOCKSIZE;
	}
	textbuf->ptr = textbuf->base + textbuf->cnt;
	tptr = (char *) textbuf->ptr;
	for (ii=0; ii<len; ii++)
	{
		*tptr = *string;
		++tptr;
		++string;
	}	
	*tptr++ = ' ';
	*tptr = '\0';
	textbuf->ptr += len + 1;
	textbuf->cnt += len + 1;
	return(0);
}

