/*
 * Decompiled with CFR 0.152.
 */
package com.pme.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class MeasurementFile {
    public String sensorSN;
    public String revisionLine;
    public double OSrevision;
    public int Type;
    public int Scrub;
    public int Angle;
    public int Timeout;
    public int Threshold;
    public String captionLine;
    public long scanTime;
    public double Battery;
    public double T;
    public int Wipes;
    public double CalWipeTime;
    public double WipeTime;
    public double StartCurrent;
    public double AverageCurrent;
    public double PeakCurrent;
    public double FinalCurrent;
    public double RSource;
    public long length;
    public int NScan;
    private BufferedReader measurementFileReader = null;

    public MeasurementFile(String pathname, String filename) throws IOException {
        int i;
        String[] captionarray;
        String captionLine;
        File measurementFile = new File(pathname + File.separatorChar + filename);
        this.length = measurementFile.length();
        if (this.length == 0L) {
            return;
        }
        this.measurementFileReader = new BufferedReader(new FileReader(pathname + File.separatorChar + filename));
        this.sensorSN = this.measurementFileReader.readLine();
        this.revisionLine = this.measurementFileReader.readLine();
        String osr = this.revisionLine.replace("OS REV:", "").trim();
        this.OSrevision = Double.parseDouble(osr);
        if (this.OSrevision <= 2.27) {
            captionLine = this.measurementFileReader.readLine();
            captionLine = captionLine.replace("Scrub:", "");
            captionLine = captionLine.replace("Angle:", "");
            captionarray = captionLine.split(",");
            for (i = 0; i < captionarray.length; ++i) {
                captionarray[i] = captionarray[i].trim();
            }
            this.Scrub = Integer.parseInt(captionarray[0]);
            this.Angle = Integer.parseInt(captionarray[1]);
            this.Type = 0;
        } else {
            captionLine = this.measurementFileReader.readLine();
            captionLine = captionLine.replace("Type:", "");
            captionLine = captionLine.replace("Scrub:", "");
            captionLine = captionLine.replace("Angle:", "");
            captionarray = captionLine.split(",");
            for (i = 0; i < captionarray.length; ++i) {
                captionarray[i] = captionarray[i].trim();
            }
            this.Type = Integer.parseInt(captionarray[0]);
            this.Scrub = Integer.parseInt(captionarray[1]);
            this.Angle = Integer.parseInt(captionarray[2]);
        }
        this.captionLine = this.measurementFileReader.readLine();
        this.captionLine = this.captionLine.replace("Timeout:", "");
        this.captionLine = this.captionLine.replace("Threshold:", "");
        String[] captionarray2 = this.captionLine.split(",");
        for (int i2 = 0; i2 < captionarray2.length; ++i2) {
            captionarray2[i2] = captionarray2[i2].trim();
        }
        this.Timeout = Integer.parseInt(captionarray2[0]);
        this.Threshold = Integer.parseInt(captionarray2[1]);
        this.captionLine = this.measurementFileReader.readLine();
    }

    public int readScan() throws IOException, NumberFormatException {
        String myscan = this.measurementFileReader.readLine();
        if (myscan == null) {
            return -1;
        }
        String[] lineElements = myscan.split(",");
        for (int i = 0; i < lineElements.length; ++i) {
            lineElements[i] = lineElements[i].trim();
        }
        this.scanTime = Long.parseLong(lineElements[0]);
        this.Battery = Double.parseDouble(lineElements[1]);
        this.T = Double.parseDouble(lineElements[2]);
        this.Wipes = Integer.parseInt(lineElements[3]);
        this.CalWipeTime = Double.parseDouble(lineElements[4]);
        this.WipeTime = Double.parseDouble(lineElements[5]);
        this.StartCurrent = Double.parseDouble(lineElements[6]);
        this.AverageCurrent = Double.parseDouble(lineElements[7]);
        this.PeakCurrent = Double.parseDouble(lineElements[8]);
        this.FinalCurrent = Double.parseDouble(lineElements[9]);
        this.RSource = Double.parseDouble(lineElements[10]);
        return 0;
    }

    public void close() throws IOException {
        this.measurementFileReader.close();
    }
}

